/*
 * Decompiled with CFR 0.152.
 */
package io.github.quickmsg.rule;

import io.github.quickmsg.common.rule.RuleDefinition;
import io.github.quickmsg.common.rule.source.Source;
import io.github.quickmsg.rule.RuleNode;
import io.github.quickmsg.rule.node.DatabaseRuleNode;
import io.github.quickmsg.rule.node.EmptyNode;
import io.github.quickmsg.rule.node.PredicateRuleNode;
import io.github.quickmsg.rule.node.TransmitRuleNode;
import java.util.LinkedList;
import java.util.List;
import reactor.core.publisher.Mono;
import reactor.util.context.ContextView;

public class RuleChain {
    public static final RuleChain INSTANCE = new RuleChain();
    private LinkedList<RuleNode> ruleNodeList = new LinkedList();

    private RuleChain() {
    }

    public void addRules(List<RuleDefinition> definitions) {
        RuleNode rootNode;
        RuleNode preNode = rootNode = this.parseNode(definitions.get(0));
        for (int i = 1; i < definitions.size(); ++i) {
            RuleNode node = this.parseNode(definitions.get(i));
            preNode.setNextRuleNode(node);
            preNode = node;
        }
        this.ruleNodeList.addLast(rootNode);
    }

    private RuleNode parseNode(RuleDefinition definition) {
        switch (definition.getRuleType()) {
            case HTTP: {
                return new TransmitRuleNode(Source.HTTP, definition.getScript());
            }
            case PREDICATE: {
                return new PredicateRuleNode(definition.getScript());
            }
            case KAFKA: {
                return new TransmitRuleNode(Source.KAFKA, definition.getScript());
            }
            case ROCKET_MQ: {
                return new TransmitRuleNode(Source.ROCKET_MQ, definition.getScript());
            }
            case RABBIT_MQ: {
                return new TransmitRuleNode(Source.RABBIT_MQ, definition.getScript());
            }
            case DATA_BASE: {
                return new DatabaseRuleNode(definition.getScript());
            }
            case MQTT: {
                return new TransmitRuleNode(Source.MQTT, definition.getScript());
            }
        }
        return new EmptyNode();
    }

    public Mono<Void> executeRule(ContextView contextView) {
        return Mono.fromRunnable(() -> this.ruleNodeList.forEach(ruleNode -> ruleNode.execute(contextView)));
    }

    public LinkedList<RuleNode> getRuleNodeList() {
        return this.ruleNodeList;
    }
}

