/*
 * Decompiled with CFR 0.152.
 */
package io.github.quickmsg.source.db;

import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import io.github.quickmsg.common.rule.source.Source;
import io.github.quickmsg.common.rule.source.SourceBean;
import java.sql.Connection;
import java.util.Map;
import java.util.Properties;
import org.jooq.DSLContext;
import org.jooq.impl.DSL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DbSourceBean
implements SourceBean {
    private static final Logger log = LoggerFactory.getLogger(DbSourceBean.class);
    private HikariDataSource hikariDataSource;

    public Boolean support(Source source) {
        return source == Source.DATA_BASE;
    }

    public Boolean bootstrap(Map<String, Object> sourceParam) {
        Properties properties = new Properties();
        for (String key : sourceParam.keySet()) {
            properties.put(key.replaceAll("-", "."), sourceParam.get(key).toString());
        }
        try {
            HikariConfig config = new HikariConfig(properties);
            this.hikariDataSource = new HikariDataSource(config);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public void transmit(Object object) {
        try (Connection connection = this.hikariDataSource.getConnection();){
            DSLContext dslContext = DSL.using((Connection)connection);
            dslContext.execute(object.toString());
        }
        catch (Exception e) {
            log.error("execute sql error", (Throwable)e);
        }
    }

    public void close() {
        this.hikariDataSource.close();
    }
}

