/*
 * Decompiled with CFR 0.152.
 */
package io.github.quickmsg.source.db.config;

import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import io.github.quickmsg.common.db.ConnectionProvider;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HikariCPConnectionProvider
implements ConnectionProvider {
    private static final Logger log = LoggerFactory.getLogger(HikariCPConnectionProvider.class);
    private static HikariCPConnectionProvider connectionProvider = new HikariCPConnectionProvider();
    private HikariDataSource hikariDataSource;
    private AtomicInteger startUp = new AtomicInteger(0);

    private HikariCPConnectionProvider() {
    }

    public static HikariCPConnectionProvider singleTon() {
        return connectionProvider;
    }

    public void init(Properties properties) {
        if (this.startUp.compareAndSet(0, 1)) {
            try {
                HikariConfig config = new HikariConfig(properties);
                this.hikariDataSource = new HikariDataSource(config);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public Connection getConnection() {
        try {
            return this.hikariDataSource.getConnection();
        }
        catch (SQLException e) {
            log.error("getConnection error", (Throwable)e);
            return null;
        }
    }

    public void shutdown() {
        if (this.hikariDataSource != null) {
            this.hikariDataSource.close();
        }
    }
}

