/*
 * Decompiled with CFR 0.152.
 */
package io.github.quickmsg.source.mqtt;

import io.github.quickmsg.common.rule.source.Source;
import io.github.quickmsg.common.rule.source.SourceBean;
import io.github.quickmsg.common.utils.JacksonUtil;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KafkaSourceBean
implements SourceBean {
    private static final Logger log = LoggerFactory.getLogger(KafkaSourceBean.class);
    private KafkaProducer<String, Object> producer;
    private String topic;

    public Boolean support(Source source) {
        return source == Source.KAFKA;
    }

    public Boolean bootstrap(Map<String, Object> sourceParam) {
        try {
            Properties props = new Properties();
            for (String key : sourceParam.keySet()) {
                props.put(key.replaceAll("-", "."), sourceParam.get(key));
            }
            this.topic = Optional.ofNullable(sourceParam.get("topic")).map(String::valueOf).orElse("smqtt");
            this.producer = new KafkaProducer(props);
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public void transmit(Object object) {
        if (this.producer != null) {
            ProducerRecord record = new ProducerRecord(this.topic, (Object)JacksonUtil.dynamicJson((Object)object));
            this.producer.send(record);
        }
    }

    public void close() {
        if (this.producer != null) {
            this.producer.close();
        }
    }
}

