/*
 * Decompiled with CFR 0.152.
 */
package io.github.quickmsg.source.mqtt;

import com.hivemq.client.mqtt.MqttClient;
import com.hivemq.client.mqtt.datatypes.MqttQos;
import com.hivemq.client.mqtt.mqtt3.Mqtt3AsyncClient;
import com.hivemq.client.mqtt.mqtt3.Mqtt3ClientBuilder;
import com.hivemq.client.mqtt.mqtt3.message.auth.Mqtt3SimpleAuthBuilder;
import com.hivemq.client.mqtt.mqtt3.message.connect.Mqtt3ConnectBuilder;
import com.hivemq.client.mqtt.mqtt3.message.publish.Mqtt3PublishBuilder;
import io.github.quickmsg.common.rule.source.Source;
import io.github.quickmsg.common.rule.source.SourceBean;
import io.netty.util.internal.StringUtil;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MqttSourceBean
implements SourceBean {
    private static final Logger log = LoggerFactory.getLogger(MqttSourceBean.class);
    private Mqtt3AsyncClient client;

    public Boolean support(Source source) {
        return source == Source.MQTT;
    }

    public Boolean bootstrap(Map<String, Object> sourceParam) {
        try {
            String clientId = sourceParam.get("clientId").toString();
            String host = sourceParam.get("host").toString();
            Integer port = Integer.parseInt(sourceParam.get("port").toString());
            this.client = ((Mqtt3ClientBuilder)((Mqtt3ClientBuilder)((Mqtt3ClientBuilder)MqttClient.builder().useMqttVersion3().identifier(clientId)).serverHost(host)).serverPort(port.intValue())).buildAsync();
            Mqtt3ConnectBuilder.Send completableFutureSend = this.client.connectWith();
            if (sourceParam.get("userName") != null && sourceParam.get("passWord") != null) {
                String userName = sourceParam.get("userName").toString();
                String passWord = sourceParam.get("passWord").toString();
                if (!StringUtil.isNullOrEmpty((String)userName) && !StringUtil.isNullOrEmpty((String)passWord)) {
                    ((Mqtt3SimpleAuthBuilder.Nested.Complete)((Mqtt3SimpleAuthBuilder.Nested.Complete)completableFutureSend.simpleAuth().username(userName)).password(passWord.getBytes())).applySimpleAuth();
                }
            }
            ((CompletableFuture)completableFutureSend.send()).whenComplete((connAck, throwable) -> {
                if (throwable != null) {
                    log.error("mqtt client connect error", throwable);
                }
            });
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public void transmit(Object param) {
        Map object = (Map)param;
        String topic = (String)object.get("topic");
        if (topic == null) {
            log.error("MqttSourceBean transmit topic is not null");
            return;
        }
        byte[] bytes = Optional.ofNullable(object.get("msg")).map(msg -> msg.toString().getBytes(StandardCharsets.UTF_8)).orElseGet(() -> new byte[0]);
        boolean retain = Optional.ofNullable(object.get("retain")).map(r -> Boolean.getBoolean(r.toString())).orElse(false);
        Integer qos = Optional.ofNullable((Integer)object.get("qos")).orElse(0);
        ((CompletableFuture)((Mqtt3PublishBuilder.Send.Complete)((Mqtt3PublishBuilder.Send.Complete)((Mqtt3PublishBuilder.Send.Complete)((Mqtt3PublishBuilder.Send.Complete)this.client.publishWith().topic(topic)).payload(bytes)).qos(Objects.requireNonNull(MqttQos.fromCode((int)qos)))).retain(retain)).send()).whenComplete((publish, throwable) -> {
            if (throwable != null) {
                log.error("mqtt client publish error", throwable);
            }
        });
    }

    public void close() {
        if (this.client != null) {
            this.client.disconnect();
        }
    }
}

