/*
 * Decompiled with CFR 0.152.
 */
package io.github.quickmsg.source.rabbitmq;

import com.rabbitmq.client.Channel;
import com.rabbitmq.client.Connection;
import com.rabbitmq.client.ConnectionFactory;
import io.github.quickmsg.common.rule.source.Source;
import io.github.quickmsg.common.rule.source.SourceBean;
import io.github.quickmsg.common.utils.JacksonUtil;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RabbitmqSourceBean
implements SourceBean {
    private static final Logger log = LoggerFactory.getLogger(RabbitmqSourceBean.class);
    private Connection connection = null;
    private Map<String, Channel> channelHashMap = new HashMap<String, Channel>();
    private String queueName;

    public Boolean support(Source source) {
        return source == Source.RABBIT_MQ;
    }

    public Boolean bootstrap(Map<String, Object> sourceParam) {
        try {
            ConnectionFactory factory = new ConnectionFactory();
            factory.setAutomaticRecoveryEnabled(true);
            factory.setTopologyRecoveryEnabled(true);
            factory.setNetworkRecoveryInterval(3000);
            factory.setHost(sourceParam.get("host").toString());
            factory.setPort(Integer.parseInt(sourceParam.get("port").toString()));
            factory.setUsername(sourceParam.get("userName").toString());
            factory.setPassword(sourceParam.get("passWord").toString());
            this.connection = factory.newConnection();
            this.queueName = sourceParam.get("queueName").toString();
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public void transmit(Object object) {
        this.corePublish(this.queueName, JacksonUtil.dynamicJson((Object)object));
    }

    public void corePublish(String queueName, String json) {
        try {
            Channel cacheChannel = this.channelHashMap.get(queueName);
            Channel channel = null;
            if (cacheChannel == null) {
                channel = this.connection.createChannel();
                this.channelHashMap.put(queueName, channel);
            } else {
                channel = cacheChannel;
            }
            channel.queueDeclare(queueName, false, false, false, null);
            channel.basicPublish("", queueName, null, json.getBytes("UTF-8"));
        }
        catch (Exception e) {
            log.error("RabbitMq\u8f6c\u53d1\u5f02\u5e38", (Throwable)e);
        }
    }

    public void close() {
        try {
            for (Map.Entry<String, Channel> stringChannelEntry : this.channelHashMap.entrySet()) {
                Channel channel = stringChannelEntry.getValue();
                channel.close();
            }
            this.connection.close();
        }
        catch (Exception e) {
            log.error("#Close.Exception: {}", (Object)e.getMessage());
        }
    }
}

