/*
 * Decompiled with CFR 0.152.
 */
package io.github.quickmsg.source.rocketmq;

import io.github.quickmsg.common.rule.source.Source;
import io.github.quickmsg.common.rule.source.SourceBean;
import io.github.quickmsg.common.utils.JacksonUtil;
import java.util.Map;
import java.util.Optional;
import org.apache.rocketmq.client.producer.DefaultMQProducer;
import org.apache.rocketmq.client.producer.SendResult;
import org.apache.rocketmq.common.message.Message;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RocketmqSourceBean
implements SourceBean {
    private static final Logger log = LoggerFactory.getLogger(RocketmqSourceBean.class);
    private DefaultMQProducer producer;
    private String topic;
    private String tags;

    public Boolean support(Source source) {
        return source == Source.ROCKET_MQ;
    }

    public Boolean bootstrap(Map<String, Object> sourceParam) {
        try {
            this.topic = Optional.ofNullable(sourceParam.get("topic")).map(String::valueOf).orElse("smqtt");
            this.tags = sourceParam.get("tags").toString();
            this.producer = new DefaultMQProducer(sourceParam.get("producerGroup").toString());
            this.producer.setNamesrvAddr(sourceParam.get("namesrvAddr").toString());
            this.producer.setInstanceName(sourceParam.get("instanceName").toString());
            this.producer.start();
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public void transmit(Object object) {
        if (this.producer != null) {
            Message message = new Message(this.topic, this.tags, JacksonUtil.dynamicJson((Object)object).getBytes());
            try {
                SendResult sendResult = this.producer.send(message);
                log.info("rocketMq send status {}", (Object)sendResult.getSendStatus());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void close() {
        if (this.producer != null) {
            this.producer.shutdown();
        }
    }
}

