/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.sitegen;

import io.helidon.config.Config;
import io.helidon.sitegen.AbstractBuilder;
import io.helidon.sitegen.BackendProvider;
import io.helidon.sitegen.Helper;
import io.helidon.sitegen.Model;
import io.helidon.sitegen.PageRenderer;
import io.helidon.sitegen.RenderingContext;
import java.util.Map;

public abstract class Backend
implements Model {
    private static final String NAME_PROP = "name";
    private static final String CONFIG_NODE_PROP = "confignode";
    private final String name;

    protected Backend(String name) {
        Helper.checkNonNullNonEmpty(name, NAME_PROP);
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public abstract void generate(RenderingContext var1);

    public abstract Map<String, PageRenderer> pageRenderers();

    public PageRenderer getPageRenderer(String ext) {
        Map<String, PageRenderer> pageRenderers = this.pageRenderers();
        Helper.checkNonNull(pageRenderers, "pageRenderers");
        PageRenderer renderer = pageRenderers.get(ext);
        if (renderer == null) {
            throw new IllegalArgumentException("no renderer found for extension: " + ext);
        }
        return renderer;
    }

    @Override
    public Object get(String attr) {
        throw new IllegalArgumentException("Unkown attribute: " + attr);
    }

    public static <T extends Backend> Builder<T> builder() {
        return new Builder();
    }

    public static class Builder<T extends Backend>
    extends AbstractBuilder<T> {
        public Builder name(String name) {
            this.put(Backend.NAME_PROP, name);
            return this;
        }

        public Builder config(Config node) {
            if (node.exists()) {
                node.get(Backend.NAME_PROP).ifExists(c -> this.put(Backend.NAME_PROP, c.asString()));
                this.put(Backend.CONFIG_NODE_PROP, node);
            }
            return this;
        }

        @Override
        public T build() {
            String name = null;
            Config node = null;
            block8: for (Map.Entry<String, Object> entry : this.values()) {
                String attr = entry.getKey();
                Object val = entry.getValue();
                switch (attr) {
                    case "name": {
                        name = Builder.asType(val, String.class);
                        continue block8;
                    }
                    case "confignode": {
                        node = Builder.asType(val, Config.class);
                        continue block8;
                    }
                }
                throw new IllegalStateException("Unkown attribute: " + attr);
            }
            return (T)BackendProvider.get(name, node);
        }
    }
}

