/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.sitegen;

import io.helidon.common.CollectionsHelper;
import io.helidon.config.Config;
import io.helidon.sitegen.Backend;
import io.helidon.sitegen.BasicBackendProvider;
import io.helidon.sitegen.Helper;
import io.helidon.sitegen.VuetifyBackendProvider;
import java.util.List;
import java.util.ServiceLoader;

public interface BackendProvider {
    public static final List<BackendProvider> BUILTINS = CollectionsHelper.listOf((Object[])new BackendProvider[]{new BasicBackendProvider(), new VuetifyBackendProvider()});

    public Backend create(String var1, Config var2);

    public static Backend get(String backendName, Config node) {
        Backend backend;
        Helper.checkNonNullNonEmpty(backendName, "backend name");
        for (BackendProvider provider : BUILTINS) {
            backend = provider.create(backendName, node);
            if (backend == null) continue;
            return backend;
        }
        for (BackendProvider provider : ServiceLoader.load(BackendProvider.class)) {
            backend = provider.create(backendName, node);
            if (backend == null) continue;
            return backend;
        }
        throw new IllegalArgumentException("backend: " + backendName + "not found");
    }
}

