/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.sitegen;

import io.helidon.sitegen.RenderingException;
import io.helidon.sitegen.asciidoctor.AsciidocConverter;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.FileSystem;
import java.nio.file.FileSystemAlreadyExistsException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Helper {
    private static final Logger LOGGER = LoggerFactory.getLogger(Helper.class);

    public static Path loadResourceDirAsPath(String resourcePath) throws URISyntaxException, IOException, IllegalStateException {
        Path templatesDir;
        URL templatesDirURL = AsciidocConverter.class.getResource(resourcePath);
        if (templatesDirURL == null) {
            throw new IllegalStateException("resource not found: " + resourcePath);
        }
        URI templatesDirURI = templatesDirURL.toURI();
        switch (templatesDirURI.getScheme()) {
            case "jar": {
                FileSystem fs;
                try {
                    fs = FileSystems.newFileSystem(templatesDirURI, Collections.emptyMap());
                }
                catch (FileSystemAlreadyExistsException ex) {
                    fs = FileSystems.getFileSystem(templatesDirURI);
                }
                String relativePath = templatesDirURI.getSchemeSpecificPart();
                int idx = relativePath.indexOf("!");
                if (idx > 0) {
                    relativePath = relativePath.substring(idx + 1);
                }
                templatesDir = fs.getPath(relativePath, new String[0]);
                break;
            }
            case "file": {
                templatesDir = Paths.get(templatesDirURI);
                break;
            }
            default: {
                throw new IllegalStateException(templatesDirURI.toASCIIString() + " expecting jar: or file:");
            }
        }
        return templatesDir;
    }

    public static String asString(Object obj) {
        if (obj == null || !(obj instanceof String)) {
            return null;
        }
        return (String)obj;
    }

    public static void copyResources(final Path resources, final File outputdir) throws IOException {
        try {
            Files.walkFileTree(resources, (FileVisitor<? super Path>)new FileVisitor<Path>(){

                @Override
                public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    if (!Files.isDirectory(file, new LinkOption[0])) {
                        String targetRelativePath = resources.relativize(file).toString();
                        Path targetPath = outputdir.toPath().resolve(targetRelativePath);
                        Files.createDirectories(targetPath.getParent(), new FileAttribute[0]);
                        LOGGER.debug("Copying static resource: {} to {}", (Object)targetRelativePath, (Object)targetPath.toString());
                        Files.copy(file, targetPath, StandardCopyOption.REPLACE_EXISTING);
                    }
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult visitFileFailed(Path file, IOException ex) throws IOException {
                    LOGGER.error("Error while copying static resource: {} - {}", (Object)file.getFileName(), (Object)ex.getMessage());
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (IOException ex) {
            throw new RenderingException("An error occurred during static resource processing ", ex);
        }
    }

    public static void checkNonNull(Object arg, String name) throws IllegalArgumentException {
        if (arg == null) {
            throw new IllegalArgumentException(name + " is null");
        }
    }

    public static void checkNonNullNonEmpty(String arg, String name) {
        if (arg == null || arg.isEmpty()) {
            throw new IllegalArgumentException(name + " is null or empty");
        }
    }

    public static void checkNonNullExistent(File arg, String name) {
        if (arg == null) {
            throw new IllegalArgumentException(name + "is null");
        }
        if (!arg.exists()) {
            throw new IllegalArgumentException(arg.getAbsolutePath() + " does not exist");
        }
    }

    public static void checkValidFile(File arg, String name) {
        Helper.checkNonNullExistent(arg, name);
        if (!arg.isFile()) {
            throw new IllegalArgumentException(arg.getAbsolutePath() + " is not a file");
        }
    }

    public static void checkValidDir(File arg, String name) {
        Helper.checkNonNullExistent(arg, name);
        if (!arg.isDirectory()) {
            throw new IllegalArgumentException(arg.getAbsolutePath() + " is not a directory");
        }
    }

    public static String getFileExt(String filepath) {
        int index = filepath.lastIndexOf(".");
        return index < 0 ? null : filepath.substring(index + 1);
    }

    public static String replaceFileExt(String filepath, String ext) {
        String path = filepath;
        path = path.substring(0, path.lastIndexOf("."));
        return path + ext;
    }

    public static String getRelativePath(File sourcedir, File source) {
        return sourcedir.toPath().relativize(source.toPath()).toString().replace("\\", "/");
    }
}

