/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.sitegen;

import io.helidon.sitegen.Backend;
import io.helidon.sitegen.Helper;
import io.helidon.sitegen.Model;
import io.helidon.sitegen.SourcePath;
import io.helidon.sitegen.SourcePathFilter;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class Page
implements Model {
    private static final String SOURCE_PROP = "source";
    private static final String EXT_PROP = "ext";
    private static final String TARGET_PROP = "target";
    private static final String METADATA_PROP = "metadata";
    private final String sourcePath;
    private final String sourceExt;
    private final String targetPath;
    private final Metadata metadata;

    private Page(String source, String ext, String target, Metadata metadata) {
        Helper.checkNonNullNonEmpty(source, SOURCE_PROP);
        Helper.checkNonNullNonEmpty(ext, EXT_PROP);
        Helper.checkNonNullNonEmpty(target, TARGET_PROP);
        Helper.checkNonNull(metadata, METADATA_PROP);
        this.sourcePath = source;
        this.sourceExt = ext;
        this.targetPath = Helper.replaceFileExt(source, "");
        this.metadata = metadata;
    }

    public String getSourcePath() {
        return this.sourcePath;
    }

    public String getSourceExt() {
        return this.sourceExt;
    }

    public String getTargetPath() {
        return this.targetPath;
    }

    public Metadata getMetadata() {
        return this.metadata;
    }

    @Override
    public Object get(String attr) {
        switch (attr) {
            case "source": {
                return this.sourcePath;
            }
            case "ext": {
                return this.sourceExt;
            }
            case "target": {
                return this.targetPath;
            }
            case "metadata": {
                return METADATA_PROP;
            }
        }
        throw new IllegalStateException("Unkown attribute: " + attr);
    }

    public static List<Page> filter(Collection<Page> pages, Collection<String> includesPatterns, Collection<String> excludesPatterns) {
        Helper.checkNonNull(pages, "pages");
        HashMap<SourcePath, Page> sourcePaths = new HashMap<SourcePath, Page>();
        for (Page page : pages) {
            sourcePaths.put(new SourcePath(page.getSourcePath()), page);
        }
        List<SourcePath> filteredSourcePaths = SourcePath.filter(sourcePaths.keySet(), includesPatterns, excludesPatterns);
        LinkedList<Page> filtered = new LinkedList<Page>();
        for (SourcePath sourcePath : SourcePath.sort(filteredSourcePaths)) {
            Page page = (Page)sourcePaths.get(sourcePath);
            if (page == null) {
                throw new IllegalStateException("unable to get page for path: " + sourcePath.asString());
            }
            filtered.add(page);
        }
        return filtered;
    }

    public static Map<String, Page> create(List<SourcePath> sourcePaths, List<SourcePathFilter> pageFilters, File sourcedir, Backend backend) {
        List<SourcePath> filteredSourcePaths;
        Helper.checkNonNull(sourcePaths, "sourcePaths");
        Helper.checkNonNull(pageFilters, "pageFilters");
        if (pageFilters.isEmpty()) {
            filteredSourcePaths = sourcePaths;
        } else {
            filteredSourcePaths = new ArrayList<SourcePath>();
            for (SourcePathFilter pageFilter : pageFilters) {
                filteredSourcePaths.addAll(SourcePath.filter(sourcePaths, pageFilter.getIncludes(), pageFilter.getExcludes()));
            }
        }
        HashMap<String, Page> pages = new HashMap<String, Page>();
        for (SourcePath sourcePath : SourcePath.sort(filteredSourcePaths)) {
            String sourcePathStr = sourcePath.asString();
            if (pages.containsKey(sourcePathStr)) {
                throw new IllegalStateException("source path " + sourcePathStr + "already included");
            }
            String sourceExt = Helper.getFileExt(sourcePathStr);
            String targetPath = Helper.replaceFileExt(sourcePathStr, "");
            Metadata metadata = backend.getPageRenderer(sourceExt).readMetadata(new File(sourcedir, sourcePathStr));
            pages.put(sourcePathStr, new Page(sourcePathStr, sourceExt, targetPath, metadata));
        }
        return pages;
    }

    public static class Metadata
    implements Model {
        private static final String DESCRIPTION_PROP = "description";
        private static final String KEYWORDS_PROP = "keywords";
        private static final String H1_PROP = "h1";
        private static final String TITLE_PROP = "title";
        private final String description;
        private final String keywords;
        private final String h1;
        private final String title;

        public Metadata(String description, String keywords, String h1, String title) {
            Helper.checkNonNullNonEmpty(title, TITLE_PROP);
            this.description = description;
            this.keywords = keywords;
            this.h1 = h1;
            this.title = title;
        }

        public String getDescription() {
            return this.description;
        }

        public String getKeywords() {
            return this.keywords;
        }

        public String getH1() {
            return this.h1;
        }

        public String getTitle() {
            return this.title;
        }

        @Override
        public Object get(String attr) {
            switch (attr) {
                case "description": {
                    return this.description;
                }
                case "keywords": {
                    return this.keywords;
                }
                case "h1": {
                    return this.h1;
                }
                case "title": {
                    return this.title;
                }
            }
            throw new IllegalStateException("Unkown attribute: " + attr);
        }
    }
}

