/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.sitegen;

import io.helidon.sitegen.Helper;
import java.io.File;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;

public class SourcePath {
    private static final char WILDCARD = '*';
    private static final String DOUBLE_WILDCARD = "**";
    private final String[] segments;
    private static final Comparator<SourcePath> COMPARATOR = new SourceFileComparator();

    public SourcePath(File dir, File file) {
        this.segments = SourcePath.parseSegments(Helper.getRelativePath(dir, file));
    }

    public SourcePath(String path) {
        this.segments = SourcePath.parseSegments(path);
    }

    private static String[] parseSegments(String path) throws IllegalArgumentException {
        if (path == null || path.isEmpty()) {
            throw new IllegalArgumentException("path is null or empty");
        }
        String[] tokens = path.split("/");
        if (tokens.length == 0) {
            throw new IllegalArgumentException("invalid path: " + path);
        }
        LinkedList<String> segments = new LinkedList<String>();
        for (int i = 0; i < tokens.length; ++i) {
            String token = tokens[i];
            if (i < tokens.length - 1 && token.isEmpty() || token.equals(".")) continue;
            segments.add(token);
        }
        return segments.toArray(new String[segments.size()]);
    }

    public static List<SourcePath> filter(Collection<SourcePath> paths, Collection<String> includesPatterns, Collection<String> excludesPatterns) {
        if (paths == null || paths.isEmpty() || includesPatterns == null || includesPatterns.isEmpty()) {
            return Collections.emptyList();
        }
        if (excludesPatterns == null) {
            excludesPatterns = Collections.emptyList();
        }
        LinkedList<SourcePath> included = new LinkedList<SourcePath>();
        for (String includesPattern : includesPatterns) {
            for (SourcePath path : paths) {
                if (!path.matches(includesPattern)) continue;
                included.add(path);
            }
        }
        LinkedList<SourcePath> matchedRoutes = new LinkedList<SourcePath>();
        for (SourcePath path : included) {
            boolean matched = false;
            for (String excludesPattern : excludesPatterns) {
                if (!path.matches(excludesPattern)) continue;
                matched = true;
                break;
            }
            if (matched) continue;
            matchedRoutes.add(path);
        }
        return matchedRoutes;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SourcePath other = (SourcePath)obj;
        for (int i = 0; i < this.segments.length; ++i) {
            if (this.segments[i].equals(other.segments[i])) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int hash = 3;
        hash = 59 * hash + Objects.hashCode(this.segments);
        return hash;
    }

    private static boolean doRecursiveMatch(String[] segments, int offset, String[] patterns, int pOffset) {
        String pattern;
        boolean expand = false;
        while (pOffset < patterns.length && offset != segments.length) {
            pattern = patterns[pOffset];
            if (pattern.equals(DOUBLE_WILDCARD)) {
                expand = true;
            } else {
                if (expand) {
                    for (int j = 0; j < segments.length; ++j) {
                        if (!SourcePath.wildcardMatch(segments[j], pattern) || !SourcePath.doRecursiveMatch(segments, j + 1, patterns, pOffset + 1)) continue;
                        return true;
                    }
                    return false;
                }
                if (!SourcePath.wildcardMatch(segments[offset], pattern)) {
                    return false;
                }
                ++offset;
            }
            ++pOffset;
        }
        while (pOffset < patterns.length) {
            pattern = patterns[pOffset];
            if (!pattern.equals(DOUBLE_WILDCARD)) {
                return false;
            }
            ++pOffset;
        }
        return true;
    }

    public boolean matches(String pattern) {
        if (pattern == null) {
            return false;
        }
        if (pattern.isEmpty()) {
            return this.segments.length == 0;
        }
        return SourcePath.doRecursiveMatch(this.segments, 0, SourcePath.parseSegments(pattern), 0);
    }

    public static boolean wildcardMatch(String val, String pattern) {
        Objects.requireNonNull(val);
        Objects.requireNonNull(pattern);
        if (pattern.isEmpty()) {
            return val.isEmpty();
        }
        int valIdx = 0;
        int patternIdx = 0;
        boolean matched = true;
        while (matched) {
            int wildcardIdx = pattern.indexOf(42, patternIdx);
            if (wildcardIdx >= 0) {
                int patternOffset = wildcardIdx - patternIdx;
                if (patternOffset > 0) {
                    String subPattern = pattern.substring(patternIdx, wildcardIdx);
                    int idx = val.indexOf(subPattern, valIdx);
                    if (patternIdx > 0 && pattern.charAt(patternIdx - 1) == '*') {
                        if (idx < valIdx) {
                            matched = false;
                            break;
                        }
                    } else if (idx != valIdx) {
                        matched = false;
                        break;
                    }
                    valIdx = idx + subPattern.length();
                }
                patternIdx = wildcardIdx + 1;
                continue;
            }
            String subPattern = pattern.substring(patternIdx);
            String subSegment = val.substring(valIdx);
            if (patternIdx > 0 && pattern.charAt(patternIdx - 1) == '*') {
                if (subSegment.endsWith(subPattern)) break;
                matched = false;
                break;
            }
            if (subSegment.equals(subPattern)) break;
            matched = false;
            break;
        }
        return matched;
    }

    public String asString() {
        StringBuilder sb = new StringBuilder("/");
        for (int i = 0; i < this.segments.length; ++i) {
            sb.append(this.segments[i]);
            if (i >= this.segments.length - 1) continue;
            sb.append("/");
        }
        return sb.toString();
    }

    public String toString() {
        return SourcePath.class.getSimpleName() + "{ " + this.asString() + " }";
    }

    public static List<SourcePath> sort(List<SourcePath> sourcePaths) {
        Helper.checkNonNull(sourcePaths, "sourcePaths");
        sourcePaths.sort(COMPARATOR);
        return sourcePaths;
    }

    public static List<SourcePath> scan(File dir) {
        return SourcePath.doScan(dir, dir);
    }

    private static List<SourcePath> doScan(File root, File dir) {
        ArrayList<SourcePath> sourcePaths;
        block6: {
            sourcePaths = new ArrayList<SourcePath>();
            DirectoryStream<Path> dirStream = null;
            try {
                dirStream = Files.newDirectoryStream(dir.toPath());
                for (Path next : dirStream) {
                    if (Files.isDirectory(next, new LinkOption[0])) {
                        sourcePaths.addAll(SourcePath.doScan(root, next.toFile()));
                        continue;
                    }
                    sourcePaths.add(new SourcePath(root, next.toFile()));
                }
            }
            catch (IOException ex) {
                if (dirStream == null) break block6;
                try {
                    dirStream.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        return SourcePath.sort(sourcePaths);
    }

    private static class SourceFileComparator
    implements Comparator<SourcePath> {
        private SourceFileComparator() {
        }

        @Override
        public int compare(SourcePath o1, SourcePath o2) {
            for (int i = 0; i < o1.segments.length; ++i) {
                int cmp = o1.segments[i].compareTo(o2.segments[i]);
                if (cmp == 0) continue;
                return cmp;
            }
            return 0;
        }
    }
}

