/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.sitegen;

import io.helidon.config.Config;
import io.helidon.sitegen.AbstractBuilder;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class SourcePathFilter {
    private static final String INCLUDES_PROP = "includes";
    private static final String EXCLUDES_PROP = "excludes";
    private final List<String> includes;
    private final List<String> excludes;

    private SourcePathFilter(List<String> includes, List<String> excludes) {
        this.includes = includes == null ? Collections.emptyList() : includes;
        this.excludes = excludes == null ? Collections.emptyList() : excludes;
    }

    public List<String> getIncludes() {
        return this.includes;
    }

    public List<String> getExcludes() {
        return this.excludes;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    extends AbstractBuilder<SourcePathFilter> {
        public Builder includes(List<String> includes) {
            this.put(SourcePathFilter.INCLUDES_PROP, includes);
            return this;
        }

        public Builder excludes(List<String> excludes) {
            this.put(SourcePathFilter.EXCLUDES_PROP, excludes);
            return this;
        }

        public Builder config(Config node) {
            if (node.exists()) {
                node.get(SourcePathFilter.INCLUDES_PROP).ifExists(c -> this.put(SourcePathFilter.INCLUDES_PROP, c.asStringList()));
                node.get(SourcePathFilter.EXCLUDES_PROP).ifExists(c -> this.put(SourcePathFilter.EXCLUDES_PROP, c.asStringList()));
            }
            return this;
        }

        @Override
        public SourcePathFilter build() {
            List<String> includes = null;
            List<String> excludes = null;
            block8: for (Map.Entry<String, Object> entry : this.values()) {
                String attr = entry.getKey();
                Object val = entry.getValue();
                switch (attr) {
                    case "includes": {
                        includes = Builder.asList(val, String.class);
                        continue block8;
                    }
                    case "excludes": {
                        excludes = Builder.asList(val, String.class);
                        continue block8;
                    }
                }
                throw new IllegalStateException("Unkown attribute: " + attr);
            }
            return new SourcePathFilter(includes, excludes);
        }
    }
}

