/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.sitegen;

import io.helidon.config.Config;
import io.helidon.sitegen.AbstractBuilder;
import io.helidon.sitegen.Helper;
import io.helidon.sitegen.Model;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class StaticAsset
implements Model {
    private static final String TARGET_PROP = "target";
    private static final String INCLUDES_PROP = "includes";
    private static final String EXCLUDES_PROP = "excludes";
    private final String target;
    private final List<String> includes;
    private final List<String> excludes;

    private StaticAsset(String target, List<String> includes, List<String> excludes) {
        Helper.checkNonNullNonEmpty(target, TARGET_PROP);
        this.target = target;
        this.includes = includes == null ? Collections.emptyList() : includes;
        this.excludes = excludes == null ? Collections.emptyList() : excludes;
    }

    public String getTarget() {
        return this.target;
    }

    public List<String> getIncludes() {
        return this.includes;
    }

    public List<String> getExcludes() {
        return this.excludes;
    }

    @Override
    public Object get(String attr) {
        switch (attr) {
            case "target": {
                return this.target;
            }
            case "includes": {
                return this.includes;
            }
            case "excludes": {
                return this.excludes;
            }
        }
        throw new IllegalArgumentException("Unkown attribute: " + attr);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    extends AbstractBuilder<StaticAsset> {
        public Builder target(String target) {
            this.put(StaticAsset.TARGET_PROP, target);
            return this;
        }

        public Builder includes(List<String> includes) {
            this.put(StaticAsset.INCLUDES_PROP, includes);
            return this;
        }

        public Builder excludes(List<String> excludes) {
            this.put(StaticAsset.EXCLUDES_PROP, excludes);
            return this;
        }

        public Builder config(Config node) {
            if (node.exists()) {
                node.get(StaticAsset.TARGET_PROP).ifExists(c -> this.put(StaticAsset.TARGET_PROP, c.asString()));
                node.get(StaticAsset.INCLUDES_PROP).ifExists(c -> this.put(StaticAsset.INCLUDES_PROP, c.asStringList()));
                node.get(StaticAsset.EXCLUDES_PROP).ifExists(c -> this.put(StaticAsset.EXCLUDES_PROP, c.asStringList()));
            }
            return this;
        }

        @Override
        public StaticAsset build() {
            String target = null;
            List<String> includes = null;
            List<String> excludes = null;
            block10: for (Map.Entry<String, Object> entry : this.values()) {
                String attr = entry.getKey();
                Object val = entry.getValue();
                switch (attr) {
                    case "target": {
                        target = Builder.asType(val, String.class);
                        continue block10;
                    }
                    case "includes": {
                        includes = Builder.asList(val, String.class);
                        continue block10;
                    }
                    case "excludes": {
                        excludes = Builder.asList(val, String.class);
                        continue block10;
                    }
                }
                throw new IllegalStateException("Unkown attribute: " + attr);
            }
            return new StaticAsset(target, includes, excludes);
        }
    }
}

