/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.sitegen;

import io.helidon.common.CollectionsHelper;
import io.helidon.config.Config;
import io.helidon.sitegen.Backend;
import io.helidon.sitegen.Helper;
import io.helidon.sitegen.Page;
import io.helidon.sitegen.PageRenderer;
import io.helidon.sitegen.RenderingContext;
import io.helidon.sitegen.RenderingException;
import io.helidon.sitegen.SourcePath;
import io.helidon.sitegen.VuetifyNavigation;
import io.helidon.sitegen.asciidoctor.AsciidocPageRenderer;
import io.helidon.sitegen.freemarker.FreemarkerEngine;
import io.helidon.sitegen.freemarker.TemplateSession;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class VuetifyBackend
extends Backend {
    public static final String BACKEND_NAME = "vuetify";
    private static final String STATIC_RESOURCES = "/helidon-sitegen-static/vuetify";
    private static final String THEME_PROP = "theme";
    private static final String NAVIGATION_PROP = "navigation";
    private static final String HOME_PAGE_PROP = "homePage";
    private static final String RELEASES_PROP = "releases";
    private final Map<String, PageRenderer> pageRenderers;
    private final VuetifyNavigation navigation;
    private final Map<String, String> theme;
    private final Path staticResources;
    private final String homePage;
    private final List<String> releases;

    private VuetifyBackend(Map<String, String> theme, VuetifyNavigation navigation, String homePage, List<String> releases) {
        super(BACKEND_NAME);
        Helper.checkNonNullNonEmpty(homePage, HOME_PAGE_PROP);
        this.theme = theme == null ? Collections.emptyMap() : theme;
        this.navigation = navigation;
        this.homePage = homePage;
        this.releases = releases == null ? Collections.emptyList() : releases;
        this.pageRenderers = CollectionsHelper.mapOf((Object)"adoc", (Object)new AsciidocPageRenderer(BACKEND_NAME));
        try {
            this.staticResources = Helper.loadResourceDirAsPath(STATIC_RESOURCES);
        }
        catch (IOException | URISyntaxException ex) {
            throw new IllegalStateException(ex);
        }
    }

    public VuetifyNavigation getNavigation() {
        return this.navigation;
    }

    public Map<String, String> getTheme() {
        return this.theme;
    }

    public String getHomePage() {
        return this.homePage;
    }

    public List<String> getReleases() {
        return this.releases;
    }

    @Override
    public Map<String, PageRenderer> pageRenderers() {
        return this.pageRenderers;
    }

    @Override
    public void generate(RenderingContext ctx) {
        File pagesdir = new File(ctx.getOutputdir(), "pages");
        try {
            Files.createDirectories(pagesdir.toPath(), new FileAttribute[0]);
        }
        catch (IOException ex) {
            throw new RenderingException(ex.getMessage(), ex);
        }
        ctx.processPages(pagesdir, "js");
        ctx.copyStaticAssets();
        TemplateSession session = ctx.getTemplateSession();
        Page home = ctx.getPages().get(new SourcePath(this.homePage).asString());
        if (home == null) {
            throw new IllegalStateException("unable to get home page");
        }
        VuetifyNavigation resolvedNavigation = this.navigation == null ? null : this.navigation.resolve(ctx.getPages().values());
        List navRouteEntries = resolvedNavigation != null ? resolvedNavigation.getItems().stream().filter(item -> item.isGroup()).flatMap(item -> item.asGroup().getItems().stream()).filter(groupItem -> groupItem.isSubGroup()).flatMap(groupItem -> groupItem.asSubGroup().getItems().stream()).filter(subGroupItem -> subGroupItem.isLink()).map(subGroupItem -> ctx.getPageForRoute(subGroupItem.asLink().getHref()).getSourcePath()).collect(Collectors.toList()) : Collections.emptyList();
        List routeEntries = Stream.concat(navRouteEntries.contains(home.getSourcePath()) ? Stream.empty() : Stream.of(home.getSourcePath()), Stream.concat(navRouteEntries.stream(), ctx.getPages().keySet().stream().filter(item -> !navRouteEntries.contains(item)))).collect(Collectors.toList());
        Map<String, String> allBindings = session.getVueBindings().getBindings();
        HashMap<String, Object> model = new HashMap<String, Object>();
        model.put("searchEntries", session.getSearchIndex().getEntries());
        model.put("navRouteEntries", navRouteEntries);
        model.put("routeEntries", routeEntries);
        model.put("customLayoutEntries", session.getCustomLayouts().getMappings());
        model.put("pages", ctx.getPages());
        model.put("metadata", home.getMetadata());
        model.put(NAVIGATION_PROP, resolvedNavigation);
        model.put("header", ctx.getSite().getHeader());
        model.put(THEME_PROP, this.theme);
        model.put("home", home);
        model.put(RELEASES_PROP, this.releases);
        model.put("bindings", allBindings);
        FreemarkerEngine freemarker = ctx.getSite().getEngine().freemarker();
        for (Page page : ctx.getPages().values()) {
            String bindings = allBindings.get(page.getSourcePath());
            if (bindings == null) continue;
            HashMap<String, Object> bindingsModel = new HashMap<String, Object>(model);
            bindingsModel.put("bindings", bindings);
            bindingsModel.put("page", page);
            freemarker.renderFile("custom_bindings", "pages/" + page.getTargetPath() + "_custom.js", bindingsModel, ctx);
        }
        freemarker.renderFile("search_index", "main/search-index.json", model, ctx);
        freemarker.renderFile("index", "index.html", model, ctx);
        freemarker.renderFile("config", "main/config.js", model, ctx);
        try {
            Helper.copyResources(this.staticResources, ctx.getOutputdir());
        }
        catch (IOException ex) {
            throw new RenderingException("An error occurred during static resource processing ", ex);
        }
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    extends Backend.Builder<VuetifyBackend> {
        public Builder theme(Map<String, String> theme) {
            this.put(VuetifyBackend.THEME_PROP, theme);
            return this;
        }

        public Builder navigation(VuetifyNavigation navigation) {
            this.put(VuetifyBackend.NAVIGATION_PROP, navigation);
            return this;
        }

        public Builder homePage(String homePage) {
            this.put(VuetifyBackend.HOME_PAGE_PROP, homePage);
            return this;
        }

        public Builder releases(List<String> releases) {
            this.put(VuetifyBackend.RELEASES_PROP, releases);
            return this;
        }

        @Override
        public Builder config(Config node) {
            if (node.exists()) {
                node.get(VuetifyBackend.THEME_PROP).ifExists(c -> this.put(VuetifyBackend.THEME_PROP, c.detach().asMap()));
                node.get(VuetifyBackend.NAVIGATION_PROP).ifExists(c -> this.put(VuetifyBackend.NAVIGATION_PROP, VuetifyNavigation.builder().config((Config)c).build()));
                node.get(VuetifyBackend.HOME_PAGE_PROP).ifExists(c -> this.put(VuetifyBackend.HOME_PAGE_PROP, c.asString()));
                node.get(VuetifyBackend.RELEASES_PROP).ifExists(c -> this.put(VuetifyBackend.RELEASES_PROP, c.asStringList()));
            }
            return this;
        }

        @Override
        public VuetifyBackend build() {
            Map<String, String> theme = null;
            VuetifyNavigation navigation = null;
            String homePage = null;
            List<String> releases = null;
            block12: for (Map.Entry<String, Object> entry : this.values()) {
                String attr = entry.getKey();
                Object val = entry.getValue();
                switch (attr) {
                    case "theme": {
                        theme = Builder.asMap(val, String.class, String.class);
                        continue block12;
                    }
                    case "navigation": {
                        navigation = Builder.asType(val, VuetifyNavigation.class);
                        continue block12;
                    }
                    case "homePage": {
                        homePage = Builder.asType(val, String.class);
                        continue block12;
                    }
                    case "releases": {
                        releases = Builder.asList(val, String.class);
                        continue block12;
                    }
                }
                throw new IllegalStateException("Unkown attribute: " + attr);
            }
            return new VuetifyBackend(theme, navigation, homePage, releases);
        }
    }
}

