/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.sitegen;

import io.helidon.config.Config;
import io.helidon.sitegen.AbstractBuilder;
import io.helidon.sitegen.Helper;
import io.helidon.sitegen.Model;
import java.util.Map;
import java.util.Objects;

public class WebResource
implements Model {
    private static final String LOCATION_PROP = "location";
    private static final String TYPE_PROP = "type";
    private static final String PATH_PROP = "path";
    private static final String HREF_PROP = "href";
    private final Location location;
    private final String type;

    private WebResource(Location location, String type) {
        Helper.checkNonNull(location, LOCATION_PROP);
        this.location = location;
        this.type = type;
    }

    Location getLocation() {
        return this.location;
    }

    String getType() {
        return this.type;
    }

    @Override
    public Object get(String attr) {
        switch (attr) {
            case "location": {
                return this.location.getValue();
            }
            case "type": {
                return this.type;
            }
        }
        throw new IllegalArgumentException("Unkown attribute: " + attr);
    }

    public static Builder builder() {
        return new Builder();
    }

    static class Location {
        private static final String VALUE_PROP = "value";
        private static final String TYPE_PROP = "type";
        private final String value;
        private final Type type;

        private Location(Type type, String value) {
            Helper.checkNonNull((Object)type, "type");
            Helper.checkNonNullNonEmpty(value, VALUE_PROP);
            this.type = type;
            this.value = value;
        }

        public Type getType() {
            return this.type;
        }

        public String getValue() {
            return this.value;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Location other = (Location)obj;
            if (!Objects.equals(this.value, other.value)) {
                return false;
            }
            return this.type == other.type;
        }

        public int hashCode() {
            int hash = 7;
            hash = 53 * hash + Objects.hashCode(this.value);
            hash = 53 * hash + Objects.hashCode((Object)this.type);
            return hash;
        }

        static Location from(String path, String href) {
            String locationValue;
            Type locationType;
            if (path != null && !path.isEmpty() && href == null) {
                locationType = Type.PATH;
                locationValue = path;
            } else if (href != null & !href.isEmpty() && path == null) {
                locationType = Type.HREF;
                locationValue = href;
            } else {
                throw new IllegalArgumentException("Invalid location");
            }
            return new Location(locationType, locationValue);
        }

        static enum Type {
            PATH,
            HREF;

        }
    }

    public static class Builder
    extends AbstractBuilder<WebResource> {
        public Builder href(String href) {
            this.put(WebResource.HREF_PROP, href);
            return this;
        }

        public Builder path(String path) {
            this.put(WebResource.PATH_PROP, path);
            return this;
        }

        public Builder type(String type) {
            this.put(WebResource.TYPE_PROP, type);
            return this;
        }

        public Builder config(Config node) {
            if (node.exists()) {
                node.get(WebResource.PATH_PROP).ifExists(c -> this.put(WebResource.PATH_PROP, c.asString()));
                node.get(WebResource.HREF_PROP).ifExists(c -> this.put(WebResource.HREF_PROP, c.asString()));
                node.get(WebResource.TYPE_PROP).ifExists(c -> this.put(WebResource.TYPE_PROP, c.asString()));
            }
            return this;
        }

        @Override
        public WebResource build() {
            String path = null;
            String href = null;
            String type = null;
            block10: for (Map.Entry<String, Object> entry : this.values()) {
                String attr = entry.getKey();
                Object val = entry.getValue();
                switch (attr) {
                    case "path": {
                        path = Builder.asType(val, String.class);
                        continue block10;
                    }
                    case "href": {
                        href = Builder.asType(val, String.class);
                        continue block10;
                    }
                    case "type": {
                        type = Builder.asType(val, String.class);
                        continue block10;
                    }
                }
                throw new IllegalStateException("Unkown attribute: " + attr);
            }
            return new WebResource(Location.from(path, href), type);
        }
    }
}

