/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.sitegen.asciidoctor;

import io.helidon.sitegen.SiteEngine;
import io.helidon.sitegen.freemarker.FreemarkerEngine;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;
import org.asciidoctor.ast.ContentNode;
import org.asciidoctor.ast.PhraseNode;
import org.asciidoctor.converter.AbstractConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsciidocConverter
extends AbstractConverter<String> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AsciidocConverter.class);
    private final FreemarkerEngine templateEngine;

    public AsciidocConverter(String backend, Map<String, Object> opts) {
        super(backend, opts);
        this.templateEngine = SiteEngine.get(backend).freemarker();
    }

    public String convert(ContentNode node, String transform, Map<Object, Object> opts) {
        if (node != null && node.getNodeName() != null) {
            String templateName;
            if (node.equals(node.getDocument())) {
                templateName = "document";
            } else if (node.isBlock()) {
                templateName = "block_" + node.getNodeName();
            } else {
                if (node.getNodeName().equals("inline_anchor") && "@@blocklink@@".equals(((PhraseNode)node).getText())) {
                    node.getParent().getParent().getAttributes().put("_link", (PhraseNode)node);
                    return "";
                }
                templateName = node.getNodeName();
            }
            LOGGER.debug("Rendering node: {}", (Object)node);
            return this.templateEngine.renderString(templateName, node);
        }
        return "";
    }

    public void write(String output, OutputStream out) throws IOException {
        out.write(output.getBytes());
    }
}

