/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.sitegen.asciidoctor;

import io.helidon.config.Config;
import io.helidon.sitegen.AbstractBuilder;
import io.helidon.sitegen.Helper;
import io.helidon.sitegen.Page;
import io.helidon.sitegen.RenderingContext;
import io.helidon.sitegen.RenderingException;
import io.helidon.sitegen.Site;
import io.helidon.sitegen.asciidoctor.AsciidocExtensionRegistry;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.asciidoctor.Asciidoctor;
import org.asciidoctor.AttributesBuilder;
import org.asciidoctor.OptionsBuilder;
import org.asciidoctor.SafeMode;
import org.asciidoctor.ast.Document;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.bridge.SLF4JBridgeHandler;

public class AsciidocEngine {
    private static final Logger LOGGER = LoggerFactory.getLogger(AsciidocEngine.class);
    private static final String BACKEND_PROP = "backend";
    private static final String LIBRARIES_PROP = "libraries";
    private static final String ATTRIBUTES_PROP = "attributes";
    private static final String IMAGESDIR_PROP = "imagesdir";
    public static final String DEFAULT_IMAGESDIR = "./images";
    private static volatile Asciidoctor asciidoctorInstance = null;
    private final String backend;
    private final List<String> libraries;
    private final Map<String, Object> attributes;
    private final String imagesdir;
    private final Asciidoctor asciidoctor;

    public AsciidocEngine(String backend, List<String> libraries, Map<String, Object> attributes, String imagesdir) {
        Helper.checkNonNullNonEmpty(backend, BACKEND_PROP);
        AsciidocEngine.installSLF4JBridge();
        this.backend = backend;
        this.attributes = attributes == null ? Collections.emptyMap() : attributes;
        this.libraries = libraries == null ? Collections.emptyList() : libraries;
        String string = this.imagesdir = imagesdir == null ? DEFAULT_IMAGESDIR : imagesdir;
        if (asciidoctorInstance == null) {
            asciidoctorInstance = Asciidoctor.Factory.create();
        }
        this.asciidoctor = asciidoctorInstance;
        new AsciidocExtensionRegistry(backend).register(this.asciidoctor);
    }

    public void unregister() {
        this.asciidoctor.unregisterAllExtensions();
    }

    public List<String> getLibraries() {
        return this.libraries;
    }

    public Map<String, Object> getAttributes() {
        return this.attributes;
    }

    public String getImagesdir() {
        return this.imagesdir;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String parseSection0Title(File source) {
        try (BufferedReader br = new BufferedReader(new FileReader(source));){
            String line;
            do {
                if ((line = br.readLine()) == null) return null;
                if (!line.startsWith("= ")) continue;
                String string = line.substring(2).trim();
                return string;
            } while (!line.startsWith("== "));
            return null;
        }
        catch (IOException ex) {
            LOGGER.error("Error while parsing section0 title of " + source.getAbsolutePath(), (Throwable)ex);
        }
        return null;
    }

    public Map<String, Object> readDocumentHeader(File source) {
        Helper.checkValidFile(source, "source");
        OptionsBuilder optionsBuilder = OptionsBuilder.options().attributes(AttributesBuilder.attributes().attributes(this.attributes)).safe(SafeMode.UNSAFE).headerFooter(false).eruby("").baseDir(source.getParentFile()).option("parse_header_only", (Object)true);
        if (this.backend != null) {
            optionsBuilder.backend(this.backend);
        }
        Document doc = this.asciidoctor.loadFile(source, optionsBuilder.asMap());
        HashMap<String, Object> headerMap = new HashMap<String, Object>();
        String h1 = AsciidocEngine.parseSection0Title(source);
        if (h1 != null) {
            headerMap.put("h1", h1);
        }
        headerMap.putAll(doc.getAttributes());
        return headerMap;
    }

    public void render(Page page, RenderingContext ctx, File target, Map<String, Object> extraAttributes) {
        Helper.checkNonNull(page, "page");
        Helper.checkNonNull(ctx, "ctx");
        this.asciidoctor.requireLibraries(this.libraries);
        if (extraAttributes == null) {
            extraAttributes = Collections.emptyMap();
        }
        File outputdir = ctx.getOutputdir();
        File sourcedir = ctx.getSourcedir();
        File source = new File(sourcedir, page.getSourcePath());
        Helper.checkValidFile(source, "source");
        AttributesBuilder attributesBuilder = AttributesBuilder.attributes();
        attributesBuilder.attributes(extraAttributes);
        attributesBuilder.attributes(this.attributes);
        attributesBuilder.skipFrontMatter(true).experimental(true);
        if (this.imagesdir != null) {
            attributesBuilder.imagesDir(this.imagesdir);
            attributesBuilder.attribute("imagesoutdir", (Object)new File(outputdir, this.imagesdir).getPath());
        }
        String outdir = Helper.getRelativePath(source.getParentFile(), outputdir);
        attributesBuilder.attribute("outdir", (Object)outdir);
        OptionsBuilder optionsBuilder = OptionsBuilder.options();
        optionsBuilder.attributes(attributesBuilder).safe(SafeMode.UNSAFE).headerFooter(false).eruby("").baseDir(source.getParentFile()).option("parse", (Object)false);
        if (this.backend != null) {
            optionsBuilder.backend(this.backend);
        }
        LOGGER.info("rendering {} to {}", (Object)source.getPath(), (Object)target.getPath());
        Document document = this.asciidoctor.loadFile(source, optionsBuilder.asMap());
        document.setAttribute((Object)"templateSession", (Object)ctx.getTemplateSession(), true);
        String output = document.convert();
        try {
            target.getParentFile().mkdirs();
            FileWriter writer = new FileWriter(target);
            writer.write(output);
            writer.flush();
            writer.close();
        }
        catch (IOException ex) {
            throw new RenderingException(ex.getMessage(), ex);
        }
    }

    public static Builder builder() {
        return new Builder();
    }

    private static void installSLF4JBridge() {
        SLF4JBridgeHandler.removeHandlersForRootLogger();
        SLF4JBridgeHandler.install();
    }

    public static class Builder
    extends AbstractBuilder<AsciidocEngine> {
        public Builder libraries(List<String> libraries) {
            this.put(AsciidocEngine.LIBRARIES_PROP, libraries);
            return this;
        }

        public Builder attributes(Map<String, Object> attributes) {
            this.put(AsciidocEngine.ATTRIBUTES_PROP, attributes);
            return this;
        }

        public Builder imagesdir(String imagesdir) {
            this.put(AsciidocEngine.IMAGESDIR_PROP, imagesdir);
            return this;
        }

        public Builder config(Config node) {
            if (node.exists()) {
                node.get(AsciidocEngine.LIBRARIES_PROP).ifExists(c -> this.put(AsciidocEngine.LIBRARIES_PROP, c.asStringList()));
                node.get(AsciidocEngine.ATTRIBUTES_PROP).ifExists(c -> this.put(AsciidocEngine.ATTRIBUTES_PROP, c.detach().asMap()));
                node.get(AsciidocEngine.IMAGESDIR_PROP).ifExists(c -> this.put(AsciidocEngine.IMAGESDIR_PROP, c.asString()));
            }
            return this;
        }

        @Override
        public AsciidocEngine build() {
            List<String> libraries = null;
            Map<String, Object> attributes = null;
            String imagesdir = null;
            block10: for (Map.Entry<String, Object> entry : this.values()) {
                String attr = entry.getKey();
                Object val = entry.getValue();
                switch (attr) {
                    case "libraries": {
                        libraries = Builder.asList(val, String.class);
                        continue block10;
                    }
                    case "attributes": {
                        attributes = Builder.asMap(val, String.class, Object.class);
                        continue block10;
                    }
                    case "imagesdir": {
                        imagesdir = Builder.asType(val, String.class);
                        continue block10;
                    }
                }
                throw new IllegalStateException("Unkown attribute: " + attr);
            }
            String backendName = Site.THREADLOCAL.get();
            return new AsciidocEngine(backendName, libraries, attributes, imagesdir);
        }
    }
}

