/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.sitegen.asciidoctor;

import io.helidon.common.CollectionsHelper;
import io.helidon.sitegen.Helper;
import io.helidon.sitegen.Page;
import io.helidon.sitegen.PageRenderer;
import io.helidon.sitegen.RenderingContext;
import io.helidon.sitegen.SiteEngine;
import java.io.File;
import java.util.Map;

public class AsciidocPageRenderer
implements PageRenderer {
    public static final String ADOC_EXT = "adoc";
    private final String backendName;

    public AsciidocPageRenderer(String backendName) {
        this.backendName = backendName;
    }

    @Override
    public void process(Page page, RenderingContext ctx, File pagesdir, String ext) {
        Helper.checkNonNull(page, "page");
        Helper.checkNonNull(ctx, "ctx");
        Helper.checkValidDir(pagesdir, "pagesdir");
        Helper.checkNonNullNonEmpty(ext, "ext");
        SiteEngine siteEngine = SiteEngine.get(this.backendName);
        File target = new File(pagesdir, page.getTargetPath() + "." + ext);
        siteEngine.asciidoc().render(page, ctx, target, CollectionsHelper.mapOf((Object)"page", (Object)page, (Object)"pages", ctx.getPages()));
    }

    @Override
    public Page.Metadata readMetadata(File source) {
        Helper.checkNonNull(source, "source");
        SiteEngine siteEngine = SiteEngine.get(this.backendName);
        Map<String, Object> docHeader = siteEngine.asciidoc().readDocumentHeader(source);
        return new Page.Metadata(Helper.asString(docHeader.get("description")), Helper.asString(docHeader.get("keywords")), Helper.asString(docHeader.get("h1")), Helper.asString(docHeader.get("doctitle")));
    }
}

