/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.sitegen.asciidoctor;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Include {
    private static final String INCLUDE_PREFIX = "_include";
    static final Pattern INCLUDE_BRACKET_PATTERN = Pattern.compile("// _include-(start|end)::(.*)");
    static final Pattern INCLUDE_NUMBERED_PATTERN = Pattern.compile("// _include::(\\d*)-(\\d*):(.*)");
    static final Pattern ASCIIDOC_INCLUDE_PATTERN = Pattern.compile("include::(.*)");
    static final String INCLUDE_BRACKET_TEMPLATE = "// _include-%s::%s";
    private static final String INCLUDE_NUMBERED_TEMPLATE = "// _include::%d-%d:%s";
    private static final String INCLUDE_START = "_include-start";
    private static final String INCLUDE_END = "_include-end";
    private final int startWithinBlock;
    private final int endWithinBlock;
    private final List<String> body;
    private final String includeTarget;

    static boolean isIncludeStart(String line) {
        return line.startsWith("// _include-start");
    }

    static boolean isIncludeEnd(String line) {
        return line.startsWith("// _include-end");
    }

    static String targetFromIncludeStart(String line) {
        return line.substring("// _include-start::".length());
    }

    static boolean isIncludeNumbered(String line) {
        return INCLUDE_NUMBERED_PATTERN.matcher(line).matches();
    }

    static String include(String includeTarget) {
        return String.format("include::" + includeTarget, new Object[0]);
    }

    static String includeEnd(String includeTarget) {
        return String.format("// %s::%s", INCLUDE_END, includeTarget);
    }

    static String includeStart(String includeTarget) {
        return String.format("// %s::%s", INCLUDE_START, includeTarget);
    }

    Include(int startOfBlock, int startWithinBlock, int endWithinBlock, List<String> body, String includeTarget) {
        this.startWithinBlock = startWithinBlock;
        this.endWithinBlock = endWithinBlock;
        this.includeTarget = includeTarget;
        this.body = body;
    }

    static Include fromNumberedInclude(List<String> content, int startOfBlock, String numberedInclude) {
        Matcher m = INCLUDE_NUMBERED_PATTERN.matcher(numberedInclude);
        if (!m.matches()) {
            throw new IllegalStateException("Expected numbered include but did not match expected pattern - " + numberedInclude);
        }
        int startWithinBlock = Integer.parseInt(m.group(1));
        int endWithinBlock = Integer.parseInt(m.group(2));
        Include result = new Include(content, startOfBlock, startWithinBlock, endWithinBlock, m.group(3));
        return result;
    }

    static Include consumeBracketedInclude(List<String> content, AtomicInteger lineNumber, List<String> output, int startOfOutputBlock) {
        boolean endFound;
        String line = content.get(lineNumber.get());
        Matcher m = INCLUDE_BRACKET_PATTERN.matcher(line);
        if (!m.matches() || !m.group(1).equals("start")) {
            return null;
        }
        lineNumber.incrementAndGet();
        int startWithinBlock = output.size() - startOfOutputBlock;
        String includeTarget = m.group(2);
        ArrayList<String> body = new ArrayList<String>();
        do {
            line = content.get(lineNumber.getAndIncrement());
            m.reset(line);
            boolean bl = endFound = m.matches() && m.group(1).equals("end");
            if (endFound) continue;
            body.add(line);
        } while (!endFound);
        int endWithinBlock = startWithinBlock + body.size() - 1;
        return new Include(startOfOutputBlock, startWithinBlock, endWithinBlock, body, includeTarget);
    }

    private Include(List<String> content, int startOfBlock, int startWithinBlock, int endWithinBlock, String includeTarget) {
        this(startOfBlock, startWithinBlock, endWithinBlock, Include.buildBody(content, startOfBlock, startWithinBlock, endWithinBlock), includeTarget);
    }

    List<String> asBracketedAsciiDocInclude() {
        ArrayList<String> result = new ArrayList<String>();
        result.add(String.format(INCLUDE_BRACKET_TEMPLATE, "start", this.includeTarget));
        result.add("include::" + this.includeTarget);
        result.add(String.format(INCLUDE_BRACKET_TEMPLATE, "end", this.includeTarget));
        return result;
    }

    List<String> asAsciiDocInclude() {
        ArrayList<String> result = new ArrayList<String>();
        result.add(String.format("include::%s", this.includeTarget));
        return result;
    }

    String asNumberedAsciiDocInclude() {
        return String.format(INCLUDE_NUMBERED_TEMPLATE, this.startWithinBlock, this.endWithinBlock, this.includeTarget);
    }

    List<String> body() {
        return this.body;
    }

    int startWithinBlock() {
        return this.startWithinBlock;
    }

    int endWithinBlock() {
        return this.endWithinBlock;
    }

    String includeTarget() {
        return this.includeTarget;
    }

    public int hashCode() {
        int hash = 7;
        hash = 37 * hash + this.startWithinBlock;
        hash = 37 * hash + this.endWithinBlock;
        hash = 37 * hash + Objects.hashCode(this.body);
        hash = 37 * hash + Objects.hashCode(this.includeTarget);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Include other = (Include)obj;
        if (this.startWithinBlock != other.startWithinBlock) {
            return false;
        }
        if (this.endWithinBlock != other.endWithinBlock) {
            return false;
        }
        if (!Objects.equals(this.includeTarget, other.includeTarget)) {
            return false;
        }
        return Objects.equals(this.body, other.body);
    }

    public String toString() {
        return "IncludeAnalyzer{startWithinBlock=" + this.startWithinBlock + ", endWithinBlock=" + this.endWithinBlock + ", body=" + this.body + ", includeTarget=" + this.includeTarget + '}';
    }

    private static List<String> buildBody(List<String> content, int startOfBlock, int startWithinBlock, int endWithinBlock) {
        ArrayList<String> b = new ArrayList<String>();
        for (int i = startWithinBlock; i <= endWithinBlock; ++i) {
            b.add(content.get(startOfBlock + i));
        }
        return b;
    }
}

