/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.sitegen.freemarker;

import freemarker.core.Environment;
import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateDirectiveModel;
import freemarker.template.TemplateException;
import freemarker.template.TemplateExceptionHandler;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateNotFoundException;
import freemarker.template.Version;
import io.helidon.config.Config;
import io.helidon.sitegen.AbstractBuilder;
import io.helidon.sitegen.Helper;
import io.helidon.sitegen.RenderingContext;
import io.helidon.sitegen.RenderingException;
import io.helidon.sitegen.Site;
import io.helidon.sitegen.freemarker.ObjectWrapper;
import io.helidon.sitegen.freemarker.PassthroughFixDirective;
import io.helidon.sitegen.freemarker.TemplateLoader;
import io.helidon.sitegen.freemarker.TemplateSession;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Collections;
import java.util.Map;
import org.asciidoctor.ast.ContentNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FreemarkerEngine {
    private static final String BACKEND_PROP = "backend";
    private static final String DIRECTIVES_PROP = "directives";
    private static final String MODEL_PROP = "model";
    private static final String DEFAULT_ENCODING = "UTF-8";
    private static final Logger LOGGER = LoggerFactory.getLogger(FreemarkerEngine.class);
    private static final Version FREEMARKER_VERSION = Configuration.VERSION_2_3_23;
    private static final ObjectWrapper OBJECT_WRAPPER = new ObjectWrapper(FREEMARKER_VERSION);
    private final String backend;
    private final Map<String, String> directives;
    private final Map<String, String> model;
    private final Configuration freemarker;

    public FreemarkerEngine(String backend, Map<String, String> directives, Map<String, String> model) {
        Helper.checkNonNullNonEmpty(backend, BACKEND_PROP);
        this.backend = backend;
        this.directives = directives == null ? Collections.emptyMap() : directives;
        this.model = model == null ? Collections.emptyMap() : model;
        this.freemarker = new Configuration(FREEMARKER_VERSION);
        this.freemarker.setTemplateLoader((freemarker.cache.TemplateLoader)new TemplateLoader());
        this.freemarker.setDefaultEncoding(DEFAULT_ENCODING);
        this.freemarker.setObjectWrapper((freemarker.template.ObjectWrapper)OBJECT_WRAPPER);
        this.freemarker.setTemplateExceptionHandler(TemplateExceptionHandler.RETHROW_HANDLER);
        this.freemarker.setLogTemplateExceptions(false);
    }

    public Map<String, String> getDirectives() {
        return this.directives;
    }

    public Map<String, String> getModel() {
        return this.model;
    }

    public File renderFile(String template, String targetPath, Map<String, Object> model, RenderingContext ctx) throws RenderingException {
        String rendered = this.renderString(template, model, ctx.getTemplateSession());
        File target = new File(ctx.getOutputdir(), targetPath);
        target.getParentFile().mkdirs();
        try (FileWriter writer = new FileWriter(target);){
            writer.write(rendered);
        }
        catch (IOException ex) {
            throw new RenderingException("error while writing rendered output to file", ex);
        }
        return target;
    }

    public String renderString(String template, ContentNode node) throws RenderingException {
        Object session = node.getDocument().getAttribute((Object)"templateSession");
        Helper.checkNonNull(session, "document attribute 'templateSession'");
        if (!(session instanceof TemplateSession)) {
            throw new IllegalStateException("document attribute 'templateSession' is not valid");
        }
        return this.renderString(template, node, (TemplateSession)session);
    }

    public String renderString(String template, Object model) throws RenderingException {
        return this.renderString(template, model, null);
    }

    public String renderString(String template, Object model, TemplateSession session) throws RenderingException {
        String templatePath = this.backend + "/" + template;
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            Template tpl = this.freemarker.getTemplate(templatePath);
            OutputStreamWriter writer = new OutputStreamWriter(baos);
            LOGGER.debug("Applying template: {}", (Object)templatePath);
            Environment env = tpl.createProcessingEnvironment(model, (Writer)writer);
            if (session != null) {
                for (Map.Entry<String, TemplateDirectiveModel> directive : session.getDirectives().entrySet()) {
                    env.setVariable(directive.getKey(), (TemplateModel)directive.getValue());
                }
            }
            env.setVariable("helper", (TemplateModel)new io.helidon.sitegen.freemarker.Helper(OBJECT_WRAPPER));
            env.setVariable("passthroughfix", (TemplateModel)new PassthroughFixDirective());
            env.setTemplateExceptionHandler(TemplateExceptionHandler.RETHROW_HANDLER);
            env.setLogTemplateExceptions(false);
            env.process();
            return baos.toString(DEFAULT_ENCODING);
        }
        catch (TemplateNotFoundException ex) {
            LOGGER.warn("Unable to find template: {}", (Object)templatePath);
            return "";
        }
        catch (TemplateException | IOException ex) {
            throw new RenderingException("An error occurred during rendering of " + templatePath, ex);
        }
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    extends AbstractBuilder<FreemarkerEngine> {
        public Builder directives(Map<String, String> directives) {
            this.put(FreemarkerEngine.DIRECTIVES_PROP, directives);
            return this;
        }

        public Builder model(Map<String, String> model) {
            this.put(FreemarkerEngine.MODEL_PROP, model);
            return this;
        }

        public Builder config(Config node) {
            if (node.exists()) {
                node.get(FreemarkerEngine.DIRECTIVES_PROP).ifExists(n -> this.put(FreemarkerEngine.DIRECTIVES_PROP, n.detach().asMap()));
                node.get(FreemarkerEngine.MODEL_PROP).ifExists(n -> this.put(FreemarkerEngine.MODEL_PROP, n.detach().asMap()));
            }
            return this;
        }

        @Override
        public FreemarkerEngine build() {
            Map<String, String> directives = null;
            Map<String, String> model = null;
            block8: for (Map.Entry<String, Object> entry : this.values()) {
                String attr = entry.getKey();
                Object val = entry.getValue();
                switch (attr) {
                    case "directives": {
                        directives = Builder.asMap(val, String.class, String.class);
                        continue block8;
                    }
                    case "model": {
                        model = Builder.asMap(val, String.class, String.class);
                        continue block8;
                    }
                }
                throw new IllegalStateException("Unkown attribute: " + attr);
            }
            String backendName = Site.THREADLOCAL.get();
            return new FreemarkerEngine(backendName, directives, model);
        }
    }
}

