/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.sitegen.freemarker;

import freemarker.ext.beans.BeansWrapper;
import freemarker.template.TemplateHashModel;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;
import io.helidon.sitegen.Model;
import io.helidon.sitegen.Page;
import io.helidon.sitegen.freemarker.ObjectWrapper;
import io.helidon.sitegen.freemarker.SimpleMethodModel;
import java.util.Map;
import java.util.Objects;
import org.asciidoctor.ast.PhraseNode;

public class Helper
implements TemplateHashModel {
    private final ObjectWrapper objectWrapper;

    Helper(ObjectWrapper objectWrapper) {
        this.objectWrapper = objectWrapper;
    }

    public Link link(PhraseNode node) {
        if (node == null) {
            return null;
        }
        Map docAttrs = node.getDocument().getAttributes();
        Map nodeAttrs = node.getAttributes();
        return new Link((Map)docAttrs.get("pages"), (Page)docAttrs.get("page"), node.getType(), (String)nodeAttrs.get("path"), (String)nodeAttrs.get("refid"), (String)nodeAttrs.get("fragment"), node.getTarget(), (String)nodeAttrs.get("title"), node.getText(), node.getId(), (String)nodeAttrs.get("window"));
    }

    public TemplateModel get(String key) throws TemplateModelException {
        if (SimpleMethodModel.hasMethodWithName(this, key)) {
            return new SimpleMethodModel((BeansWrapper)this.objectWrapper, this, key);
        }
        return null;
    }

    public boolean isEmpty() throws TemplateModelException {
        return false;
    }

    public static class Link
    implements Model {
        private static final String XREF_ANCHOR_SELF_TYPE = "xref_anchor_self";
        private static final String XREF_ANCHOR_TYPE = "xref_anchor";
        private static final String UNKNOWN_TYPE = "?";
        private static final String DEFAULT_WINDOW = "_blank";
        private static final String SOURCE_PROP = "source";
        private static final String TARGET_PROP = "target";
        private static final String HASH_PROP = "hash";
        private static final String TITLE_PROP = "title";
        private static final String TEXT_PROP = "text";
        private static final String WINDOW_PROP = "window";
        private static final String ID_PROP = "id";
        private static final String TYPE_PROP = "type";
        private final String source;
        private final String target;
        private final String hash;
        private final String title;
        private final String text;
        private final String window;
        private final String id;
        private final String type;

        public Link(Map<String, Page> pages, Page page, String type, String path, String refid, String fragment, String target, String title, String text, String id, String window) {
            Objects.requireNonNull(pages, "pages is null");
            Objects.requireNonNull(pages, "page is null");
            Objects.requireNonNull(type, "type is null");
            switch (type) {
                case "xref": {
                    this.source = path != null ? path.replace(".html", ".adoc") : refid;
                    this.target = pages.containsKey("/" + this.source) ? pages.get("/" + this.source).getTargetPath() : "";
                    this.hash = fragment;
                    if (this.hash != null && (this.target == null || this.target.isEmpty()) || page.getTargetPath().equals(this.target)) {
                        this.type = XREF_ANCHOR_SELF_TYPE;
                        break;
                    }
                    if (this.hash != null && target != null && !this.hash.equals(this.source)) {
                        this.type = XREF_ANCHOR_TYPE;
                        break;
                    }
                    this.type = type;
                    break;
                }
                case "ref": {
                    this.hash = null;
                    this.source = null;
                    this.target = path;
                    this.type = type;
                    break;
                }
                case "bibref": {
                    this.hash = null;
                    this.source = null;
                    this.target = path;
                    this.type = type;
                    break;
                }
                default: {
                    this.type = UNKNOWN_TYPE;
                    this.hash = null;
                    this.source = null;
                    this.target = target;
                }
            }
            this.id = id == null ? "" : id;
            this.text = text == null ? "" : text;
            this.title = title == null ? "" : title;
            this.window = window == null ? DEFAULT_WINDOW : window;
        }

        public String getSource() {
            return this.source;
        }

        public String getTarget() {
            return this.target;
        }

        public String getText() {
            return this.text;
        }

        public String getTitle() {
            return this.title;
        }

        public String getType() {
            return this.type;
        }

        public String getId() {
            return this.id;
        }

        public String getWindow() {
            return this.window;
        }

        public String getHash() {
            return this.hash;
        }

        @Override
        public Object get(String attr) {
            switch (attr) {
                case "source": {
                    return this.source;
                }
                case "target": {
                    return this.target;
                }
                case "text": {
                    return this.text;
                }
                case "hash": {
                    return this.hash;
                }
                case "title": {
                    return this.title;
                }
                case "type": {
                    return this.type;
                }
                case "id": {
                    return this.id;
                }
                case "window": {
                    return this.window;
                }
            }
            throw new IllegalArgumentException("Unkown attribute: " + attr);
        }
    }
}

