/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.sitegen.freemarker;

import freemarker.ext.beans.BeansWrapper;
import freemarker.template.TemplateMethodModelEx;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Objects;

public class SimpleMethodModel
implements TemplateMethodModelEx {
    private final BeansWrapper objectWrapper;
    private final Object object;
    private final String methodName;

    public SimpleMethodModel(BeansWrapper objectWrapper, Object object, String methodName) {
        Objects.requireNonNull(objectWrapper);
        this.objectWrapper = objectWrapper;
        Objects.requireNonNull(object);
        this.object = object;
        Objects.requireNonNull(methodName);
        this.methodName = methodName;
    }

    public static boolean hasMethodWithName(Object object, String methodName) {
        for (Method m : object.getClass().getMethods()) {
            if (!m.getName().equals(methodName)) continue;
            return true;
        }
        return false;
    }

    public Object exec(List arguments) throws TemplateModelException {
        int numArgs = arguments.size();
        Object[] parameters = new Object[numArgs];
        Class[] parameterTypes = new Class[numArgs];
        for (int i = 0; i < numArgs; ++i) {
            Object e = arguments.get(i);
            if (e instanceof TemplateModel) {
                parameters[i] = this.objectWrapper.unwrap((TemplateModel)e);
            } else if (e == null) {
                parameters[i] = null;
            } else {
                throw new TemplateModelException(String.format("Unkown parameter type for method invocation: object=%s, methodname=%s, parameter=%s", this.object, this.methodName, e));
            }
            parameterTypes[i] = parameters[i] == null ? null : parameters[i].getClass();
        }
        Method method = null;
        for (Method method2 : this.object.getClass().getMethods()) {
            if (!this.methodName.equals(method2.getName())) continue;
            int paramsOffset = method2.getParameterCount() - numArgs;
            Class<?>[] mParameterTypes = method2.getParameterTypes();
            if (paramsOffset != 0 && (paramsOffset != 1 || !mParameterTypes[numArgs].isArray())) continue;
            boolean paramsMatch = true;
            for (int i = 0; i < numArgs; ++i) {
                if (parameterTypes[i] == null || mParameterTypes[i].isAssignableFrom(parameterTypes[i])) continue;
                paramsMatch = false;
                break;
            }
            if (!paramsMatch) continue;
            method = method2;
            if (paramsOffset != 1) break;
            Object[] newParameters = new Object[numArgs + 1];
            System.arraycopy(parameters, 0, newParameters, 0, numArgs);
            newParameters[numArgs] = Array.newInstance(method2.getParameterTypes()[numArgs], 0);
            parameters = newParameters;
            break;
        }
        if (method == null) {
            throw new TemplateModelException(String.format("Unable to find method to invoke: object=%s, methodname=%s, parameters=%s", this.object, this.methodName, arguments));
        }
        try {
            Object object = method.invoke(this.object, parameters);
            if (object == null) {
                return null;
            }
            return this.objectWrapper.wrap(object);
        }
        catch (IllegalAccessException | IllegalArgumentException | SecurityException | InvocationTargetException exception) {
            throw new TemplateModelException(String.format("Error during method invocation: object=%s, method=%s", this.object, this.methodName), exception);
        }
    }
}

