/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.sitegen.maven;

import io.helidon.sitegen.asciidoctor.AsciidocExtensionRegistry;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.asciidoctor.Asciidoctor;
import org.asciidoctor.AttributesBuilder;
import org.asciidoctor.OptionsBuilder;
import org.asciidoctor.SafeMode;
import org.asciidoctor.ast.Document;
import org.asciidoctor.log.LogHandler;
import org.asciidoctor.log.LogRecord;

public abstract class AbstractAsciiDocMojo
extends AbstractMojo {
    private static final String DEFAULT_SRC_DIR = "${project.basedir}";
    private static final String JRUBY_DEBUG_PROPERTY_NAME = "jruby.cli.verbose";
    @Parameter(defaultValue="${project}", readonly=true)
    private MavenProject project;
    @Parameter(property="helidon.sitegen.inputDirectory", defaultValue="${project.basedir}", required=true)
    private File inputDirectory;
    @Parameter(property="helidon.sitegen.outputDirectory", defaultValue="${project.basedir}")
    private File outputDirectory;
    @Parameter(property="helidon.sitegen.includes", required=true, defaultValue="README.adoc")
    private String[] includes;
    @Parameter(property="helidon.sitegen.excludes")
    private String[] excludes;

    public MavenProject project() {
        return this.project;
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        AbstractAsciiDocMojo.validateParams(this.inputDirectory, this.includes);
        String previousJRubyCliVerboseValue = System.getProperty(JRUBY_DEBUG_PROPERTY_NAME);
        if (this.getLog().isDebugEnabled()) {
            System.setProperty(JRUBY_DEBUG_PROPERTY_NAME, "true");
        }
        AtomicBoolean isPrelim = new AtomicBoolean();
        Asciidoctor asciiDoctor = this.createAsciiDoctor("simple", isPrelim);
        try {
            for (Path p : AbstractAsciiDocMojo.inputs(this.inputDirectory.toPath(), this.includes, this.excludes)) {
                this.processFile(asciiDoctor, this.inputDirectory.toPath(), p, isPrelim);
            }
        }
        catch (IOException ex) {
            throw new MojoExecutionException("Error collecting inputs", (Exception)ex);
        }
        finally {
            if (this.getLog().isDebugEnabled()) {
                if (previousJRubyCliVerboseValue == null) {
                    System.clearProperty(JRUBY_DEBUG_PROPERTY_NAME);
                } else {
                    System.setProperty(JRUBY_DEBUG_PROPERTY_NAME, previousJRubyCliVerboseValue);
                }
            }
        }
    }

    static Collection<Path> inputs(Path inputDirectory, String[] includes, String[] excludes) throws IOException {
        return Files.find(inputDirectory, Integer.MAX_VALUE, (path, attrs) -> AbstractAsciiDocMojo.matches(path, AbstractAsciiDocMojo.pathMatchers(inputDirectory, includes)) && !AbstractAsciiDocMojo.matches(path, AbstractAsciiDocMojo.pathMatchers(inputDirectory, excludes)), new FileVisitOption[0]).collect(Collectors.toSet());
    }

    abstract String outputType();

    void postProcessFile(Path adocFilePath, Path outputPath) throws IOException, MojoFailureException, MojoExecutionException {
    }

    void processFile(Asciidoctor asciiDoctor, Path inputDirectory, Path adocFilePath, AtomicBoolean isPrelim) throws IOException, MojoFailureException, MojoExecutionException {
        Path relativeInputPath = inputDirectory.relativize(adocFilePath);
        Path outputPath = this.outputDirectory.toPath().resolve(relativeInputPath);
        this.getLog().info((CharSequence)String.format("processing %s to format '%s' in %s", adocFilePath.toString(), this.outputType(), outputPath.toString()));
        Map<String, Object> attributes = this.projectPropertiesMap(this.project);
        isPrelim.set(true);
        Document doc = asciiDoctor.loadFile(adocFilePath.toFile(), this.asciiDoctorOptions(attributes, relativeInputPath, this.outputDirectory, inputDirectory.toAbsolutePath(), false));
        attributes.putAll(doc.getAttributes());
        isPrelim.set(false);
        asciiDoctor.loadFile(adocFilePath.toFile(), this.asciiDoctorOptions(attributes, relativeInputPath, this.outputDirectory, inputDirectory.toAbsolutePath(), true));
        this.postProcessFile(adocFilePath, outputPath);
    }

    private static Stream<PathMatcher> pathMatchers(Path inputDirectory, String[] globs) {
        return Arrays.stream(globs).map(glob -> FileSystems.getDefault().getPathMatcher("glob:" + inputDirectory + "/" + glob));
    }

    private static boolean matches(Path candidate, Stream<PathMatcher> matchers) {
        return matchers.anyMatch(m -> m.matches(candidate));
    }

    static void validateParams(File inputDirectory, String[] includes) throws MojoExecutionException {
        if (includes.length == 0) {
            throw new MojoExecutionException("You must specify at least one 'includes'");
        }
        if (!inputDirectory.exists() || !inputDirectory.isDirectory()) {
            throw new MojoExecutionException(String.format("inputDirectory %s does not exist or is not a directory", inputDirectory));
        }
    }

    private Asciidoctor createAsciiDoctor(String backendName, AtomicBoolean isPrelim) {
        Asciidoctor asciiDoctor = Asciidoctor.Factory.create();
        asciiDoctor.registerLogHandler((LogHandler)new SelectiveLogHandler(isPrelim));
        new AsciidocExtensionRegistry(backendName).register(asciiDoctor);
        return asciiDoctor;
    }

    private Map<String, Object> asciiDoctorOptions(Map<String, Object> attributes, Path inputRelativePath, File outputDirectory, Path baseDirPath, boolean runPreprocessing) {
        OptionsBuilder optionsBuilder = OptionsBuilder.options().attributes(AttributesBuilder.attributes().attributes(attributes)).safe(SafeMode.UNSAFE).headerFooter(false).baseDir(baseDirPath.toFile()).eruby("");
        if (outputDirectory != null) {
            optionsBuilder.option("preincludeOutputPath", (Object)outputDirectory.toPath().resolve(inputRelativePath));
        }
        if (runPreprocessing) {
            optionsBuilder.option("preprocessOutputType", (Object)this.outputType());
        }
        return optionsBuilder.asMap();
    }

    private Map<String, Object> projectPropertiesMap(MavenProject project) {
        Properties properties = new Properties();
        properties.putAll((Map<?, ?>)project.getProperties());
        properties.setProperty("project.groupId", project.getGroupId());
        properties.setProperty("project.artifactId", project.getArtifactId());
        properties.setProperty("project.version", project.getVersion());
        properties.setProperty("project.basedir", project.getBasedir().getAbsolutePath());
        return properties.entrySet().stream().collect(Collectors.toMap(entry -> (String)String.class.cast(entry.getKey()), entry -> entry.getValue()));
    }

    private static class SelectiveLogHandler
    implements LogHandler {
        private final AtomicBoolean isPrelim;

        private SelectiveLogHandler(AtomicBoolean isPrelim) {
            this.isPrelim = isPrelim;
        }

        public void log(LogRecord logRecord) {
            if (!this.isPrelim.get()) {
                System.err.println(logRecord.getMessage());
            }
        }
    }
}

