/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.media.common;

import io.helidon.common.http.DataChunk;
import io.helidon.common.reactive.Flow;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Logger;

public class PublisherInputStream
extends InputStream
implements Flow.Publisher<DataChunk> {
    private static final Logger LOGGER = Logger.getLogger(PublisherInputStream.class.getName());
    private final Flow.Publisher<DataChunk> originalPublisher;
    private final AtomicBoolean closed = new AtomicBoolean(false);
    private volatile CompletableFuture<DataChunk> processed = new CompletableFuture();
    private volatile Flow.Subscription subscription;
    private final AtomicBoolean subscribed = new AtomicBoolean(false);

    public PublisherInputStream(Flow.Publisher<DataChunk> originalPublisher) {
        this.originalPublisher = originalPublisher;
    }

    private static void releaseChunk(DataChunk chunk) {
        if (chunk != null && !chunk.isReleased()) {
            LOGGER.finest(() -> "Releasing chunk: " + chunk.id());
            chunk.release();
        }
    }

    @Override
    public int read() throws IOException {
        if (this.subscribed.compareAndSet(false, true)) {
            this.subscribe();
        }
        try {
            DataChunk chunk;
            while (true) {
                ByteBuffer currentBuffer;
                ByteBuffer byteBuffer = currentBuffer = (chunk = this.processed.get()) != null && !chunk.isReleased() ? chunk.data() : null;
                if (currentBuffer != null && currentBuffer.position() == 0) {
                    LOGGER.finest(() -> "Reading chunk ID: " + chunk.id());
                }
                if (currentBuffer != null && currentBuffer.remaining() > 0) {
                    return currentBuffer.get() & 0xFF;
                }
                if (this.closed.get()) break;
                this.processed = new CompletableFuture();
                PublisherInputStream.releaseChunk(chunk);
                this.subscription.request(1L);
            }
            LOGGER.finest(() -> "Ending stream: " + Optional.ofNullable(chunk).map(DataChunk::id).orElse(null));
            PublisherInputStream.releaseChunk(chunk);
            return -1;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IOException(e);
        }
        catch (ExecutionException e) {
            throw new IOException(e.getCause());
        }
    }

    public void subscribe(Flow.Subscriber<? super DataChunk> subscriber) {
        subscriber.onError((Throwable)new UnsupportedOperationException("Subscribing on this publisher is not allowed!"));
    }

    private void subscribe() {
        this.originalPublisher.subscribe((Flow.Subscriber)new Flow.Subscriber<DataChunk>(){

            public void onSubscribe(Flow.Subscription subscription) {
                PublisherInputStream.this.subscription = subscription;
                subscription.request(1L);
            }

            public void onNext(DataChunk item) {
                LOGGER.finest(() -> "Processing chunk: " + item.id());
                PublisherInputStream.this.processed.complete(item);
            }

            public void onError(Throwable throwable) {
                PublisherInputStream.this.closed.set(true);
                if (!PublisherInputStream.this.processed.completeExceptionally(throwable)) {
                    PublisherInputStream.this.processed = new CompletableFuture();
                    PublisherInputStream.this.processed.completeExceptionally(throwable);
                }
            }

            public void onComplete() {
                PublisherInputStream.this.closed.set(true);
                PublisherInputStream.this.processed.complete(null);
            }
        });
    }
}

