/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.metrics;

import io.helidon.metrics.Registry;
import java.util.Map;
import java.util.SortedMap;
import java.util.SortedSet;
import org.eclipse.microprofile.metrics.Counter;
import org.eclipse.microprofile.metrics.Gauge;
import org.eclipse.microprofile.metrics.Histogram;
import org.eclipse.microprofile.metrics.Metadata;
import org.eclipse.microprofile.metrics.Meter;
import org.eclipse.microprofile.metrics.Metric;
import org.eclipse.microprofile.metrics.MetricFilter;
import org.eclipse.microprofile.metrics.Timer;

final class FinalRegistry
extends Registry {
    private final Registry delegate;

    private FinalRegistry(Registry delegate) {
        super(delegate.registryType());
        this.delegate = delegate;
    }

    public static Registry create(Registry registry) {
        return new FinalRegistry(registry);
    }

    @Override
    public <T extends Metric> T register(String name, T metric) throws IllegalArgumentException {
        throw this.cannotRegister(name);
    }

    @Override
    public <T extends Metric> T register(String name, T metric, Metadata metadata) throws IllegalArgumentException {
        throw this.cannotRegister(name);
    }

    @Override
    public <T extends Metric> T register(Metadata metadata, T metric) throws IllegalArgumentException {
        throw this.cannotRegister(metadata.getName());
    }

    @Override
    public Counter counter(String name) {
        return this.delegate.getMetric(name).map(Counter.class::cast).orElseThrow(() -> this.cannotRegister(name));
    }

    @Override
    public Counter counter(Metadata metadata) {
        return this.counter(metadata.getName());
    }

    @Override
    public Histogram histogram(String name) {
        return this.delegate.getMetric(name).map(Histogram.class::cast).orElseThrow(() -> this.cannotRegister(name));
    }

    @Override
    public Histogram histogram(Metadata metadata) {
        return this.histogram(metadata.getName());
    }

    @Override
    public Meter meter(String name) {
        return this.delegate.getMetric(name).map(Meter.class::cast).orElseThrow(() -> this.cannotRegister(name));
    }

    @Override
    public Meter meter(Metadata metadata) {
        return this.meter(metadata.getName());
    }

    @Override
    public Timer timer(String name) {
        return this.delegate.getMetric(name).map(Timer.class::cast).orElseThrow(() -> this.cannotRegister(name));
    }

    @Override
    public Timer timer(Metadata metadata) {
        return this.timer(metadata.getName());
    }

    @Override
    public boolean remove(String name) {
        throw this.cannotDelete(name);
    }

    @Override
    public void removeMatching(MetricFilter filter) {
        throw this.cannotDelete("Matching a filter: " + filter);
    }

    @Override
    public SortedSet<String> getNames() {
        return this.delegate.getNames();
    }

    @Override
    public SortedMap<String, Gauge> getGauges() {
        return this.delegate.getGauges();
    }

    @Override
    public SortedMap<String, Gauge> getGauges(MetricFilter filter) {
        return this.delegate.getGauges(filter);
    }

    @Override
    public SortedMap<String, Counter> getCounters() {
        return this.delegate.getCounters();
    }

    @Override
    public SortedMap<String, Counter> getCounters(MetricFilter filter) {
        return this.delegate.getCounters(filter);
    }

    @Override
    public SortedMap<String, Histogram> getHistograms() {
        return this.delegate.getHistograms();
    }

    @Override
    public SortedMap<String, Histogram> getHistograms(MetricFilter filter) {
        return this.delegate.getHistograms(filter);
    }

    @Override
    public SortedMap<String, Meter> getMeters() {
        return this.delegate.getMeters();
    }

    @Override
    public SortedMap<String, Meter> getMeters(MetricFilter filter) {
        return this.delegate.getMeters(filter);
    }

    @Override
    public SortedMap<String, Timer> getTimers() {
        return this.delegate.getTimers();
    }

    @Override
    public SortedMap<String, Timer> getTimers(MetricFilter filter) {
        return this.delegate.getTimers(filter);
    }

    @Override
    public Map<String, Metric> getMetrics() {
        return this.delegate.getMetrics();
    }

    @Override
    public Map<String, Metadata> getMetadata() {
        return this.delegate.getMetadata();
    }

    private UnsupportedOperationException cannotDelete(String name) {
        return new UnsupportedOperationException("Cannot delete a metric \"" + name + "\" from final registry of type: " + this.type());
    }

    private UnsupportedOperationException cannotRegister(String name) {
        return new UnsupportedOperationException("Cannot register a metric \"" + name + "\" to a final registry of type: " + this.type());
    }
}

