/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.metrics;

import io.helidon.metrics.MetricImpl;
import java.util.Optional;
import java.util.concurrent.atomic.LongAdder;
import javax.json.JsonObjectBuilder;
import org.eclipse.microprofile.metrics.Counter;
import org.eclipse.microprofile.metrics.Metadata;

final class HelidonCounter
extends MetricImpl
implements Counter {
    private final Counter delegate;

    private HelidonCounter(String registryType, Metadata metadata, Counter delegate) {
        super(registryType, metadata);
        this.delegate = delegate;
    }

    static HelidonCounter create(String registryType, Metadata metadata) {
        return HelidonCounter.create(registryType, metadata, new CounterImpl());
    }

    static HelidonCounter create(String registryType, Metadata metadata, Counter metric) {
        return new HelidonCounter(registryType, metadata, metric);
    }

    public void inc() {
        this.delegate.inc();
    }

    public void inc(long n) {
        this.delegate.inc(n);
    }

    public void dec() {
        this.delegate.dec();
    }

    public void dec(long n) {
        this.delegate.dec(n);
    }

    public long getCount() {
        return this.delegate.getCount();
    }

    @Override
    protected void prometheusData(StringBuilder sb, String name, String tags) {
        String nameWithUnits = this.prometheusNameWithUnits(name, Optional.empty());
        this.prometheusType(sb, nameWithUnits, this.getType());
        this.prometheusHelp(sb, nameWithUnits);
        sb.append(nameWithUnits).append(tags).append(" ").append(this.getCount()).append('\n');
    }

    @Override
    public void jsonData(JsonObjectBuilder builder) {
        builder.add(this.getName(), this.getCount());
    }

    private static class CounterImpl
    implements Counter {
        private final LongAdder adder = new LongAdder();

        private CounterImpl() {
        }

        public void inc() {
            this.adder.increment();
        }

        public void inc(long n) {
            this.adder.add(n);
        }

        public void dec() {
            this.adder.decrement();
        }

        public void dec(long n) {
            this.adder.add(-n);
        }

        public long getCount() {
            return this.adder.sum();
        }
    }
}

