/*
 * Decompiled with CFR 0.152.
 */
package io.jsonwebtoken.impl.lang;

import io.jsonwebtoken.impl.lang.UnavailableImplementationException;
import io.jsonwebtoken.lang.Assert;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ServiceLoader;

public final class Services {
    private Services() {
    }

    public static <T> List<T> loadAll(Class<T> spi) {
        Assert.notNull(spi, (String)"Parameter 'spi' must not be null.");
        ServiceLoader<T> serviceLoader = ServiceLoader.load(spi);
        ArrayList<T> implementations = new ArrayList<T>();
        for (T implementation : serviceLoader) {
            implementations.add(implementation);
        }
        if (implementations.isEmpty()) {
            throw new UnavailableImplementationException(spi);
        }
        return Collections.unmodifiableList(implementations);
    }

    public static <T> T loadFirst(Class<T> spi) {
        Assert.notNull(spi, (String)"Parameter 'spi' must not be null.");
        ServiceLoader<T> serviceLoader = ServiceLoader.load(spi);
        if (serviceLoader.iterator().hasNext()) {
            return serviceLoader.iterator().next();
        }
        throw new UnavailableImplementationException(spi);
    }
}

