/*
 * Decompiled with CFR 0.152.
 */
package io.lettuce.core.metrics;

import io.lettuce.core.internal.LettuceAssert;
import io.lettuce.core.metrics.CommandLatencyCollectorOptions;
import java.util.concurrent.TimeUnit;

public class DefaultCommandLatencyCollectorOptions
implements CommandLatencyCollectorOptions {
    public static final TimeUnit DEFAULT_TARGET_UNIT = TimeUnit.MICROSECONDS;
    public static final double[] DEFAULT_TARGET_PERCENTILES = new double[]{50.0, 90.0, 95.0, 99.0, 99.9};
    public static final boolean DEFAULT_RESET_LATENCIES_AFTER_EVENT = true;
    public static final boolean DEFAULT_LOCAL_DISTINCTION = false;
    public static final boolean DEFAULT_ENABLED = true;
    private static final DefaultCommandLatencyCollectorOptions DISABLED = DefaultCommandLatencyCollectorOptions.builder().disable().build();
    private final TimeUnit targetUnit;
    private final double[] targetPercentiles;
    private final boolean resetLatenciesAfterEvent;
    private final boolean localDistinction;
    private final boolean enabled;
    private final Builder builder;

    protected DefaultCommandLatencyCollectorOptions(Builder builder) {
        this.targetUnit = builder.targetUnit;
        this.targetPercentiles = builder.targetPercentiles;
        this.resetLatenciesAfterEvent = builder.resetLatenciesAfterEvent;
        this.localDistinction = builder.localDistinction;
        this.enabled = builder.enabled;
        this.builder = builder;
    }

    public static DefaultCommandLatencyCollectorOptions create() {
        return DefaultCommandLatencyCollectorOptions.builder().build();
    }

    public static DefaultCommandLatencyCollectorOptions disabled() {
        return DISABLED;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public Builder mutate() {
        return this.builder;
    }

    @Override
    public TimeUnit targetUnit() {
        return this.targetUnit;
    }

    @Override
    public double[] targetPercentiles() {
        double[] result = new double[this.targetPercentiles.length];
        System.arraycopy(this.targetPercentiles, 0, result, 0, this.targetPercentiles.length);
        return result;
    }

    @Override
    public boolean resetLatenciesAfterEvent() {
        return this.resetLatenciesAfterEvent;
    }

    @Override
    public boolean localDistinction() {
        return this.localDistinction;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    public static class Builder
    implements CommandLatencyCollectorOptions.Builder {
        private TimeUnit targetUnit = DEFAULT_TARGET_UNIT;
        private double[] targetPercentiles = DEFAULT_TARGET_PERCENTILES;
        private boolean resetLatenciesAfterEvent = true;
        private boolean localDistinction = false;
        private boolean enabled = true;

        private Builder() {
        }

        @Override
        public Builder disable() {
            this.enabled = false;
            return this;
        }

        @Override
        public Builder enable() {
            this.enabled = true;
            return this;
        }

        @Override
        public Builder targetUnit(TimeUnit targetUnit) {
            LettuceAssert.notNull((Object)targetUnit, "TargetUnit must not be null");
            this.targetUnit = targetUnit;
            return this;
        }

        @Override
        public Builder targetPercentiles(double[] targetPercentiles) {
            LettuceAssert.notNull(targetPercentiles, "TargetPercentiles must not be null");
            this.targetPercentiles = targetPercentiles;
            return this;
        }

        @Override
        public Builder resetLatenciesAfterEvent(boolean resetLatenciesAfterEvent) {
            this.resetLatenciesAfterEvent = resetLatenciesAfterEvent;
            return this;
        }

        @Override
        public Builder localDistinction(boolean localDistinction) {
            this.localDistinction = localDistinction;
            return this;
        }

        @Override
        public DefaultCommandLatencyCollectorOptions build() {
            return new DefaultCommandLatencyCollectorOptions(this);
        }
    }
}

