/*
 * Decompiled with CFR 0.152.
 */
package io.minio;

import io.minio.Time;
import java.time.ZonedDateTime;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import okhttp3.Headers;

public class ObjectStat {
    private final String bucketName;
    private final String name;
    private final ZonedDateTime createdTime;
    private final long length;
    private final String etag;
    private final String contentType;
    private final Map<String, List<String>> httpHeaders;

    public ObjectStat(String bucketName, String name, Headers headers) {
        this.bucketName = bucketName;
        this.name = name;
        this.contentType = headers.get("Content-Type");
        String dateString = headers.get("Last-Modified");
        this.createdTime = ZonedDateTime.parse(dateString, Time.HTTP_HEADER_DATE_FORMAT);
        String lengthString = headers.get("Content-Length");
        this.length = Long.parseLong(lengthString);
        String etagString = headers.get("ETag");
        this.etag = etagString != null ? etagString.replaceAll("\"", "") : "";
        this.httpHeaders = Collections.unmodifiableMap(headers.toMultimap());
    }

    @Deprecated
    public ObjectStat(String bucketName, String name, ZonedDateTime createdTime, long length, String etag, String contentType) {
        this.bucketName = bucketName;
        this.name = name;
        this.contentType = contentType;
        this.createdTime = createdTime;
        this.length = length;
        this.etag = etag != null ? etag.replaceAll("\"", "") : "";
        this.httpHeaders = null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ObjectStat that = (ObjectStat)o;
        if (this.length != that.length) {
            return false;
        }
        if (!this.bucketName.equals(that.bucketName)) {
            return false;
        }
        if (!this.name.equals(that.name)) {
            return false;
        }
        if (!this.createdTime.equals(that.createdTime)) {
            return false;
        }
        if (!this.etag.equals(that.etag)) {
            return false;
        }
        return this.contentType.equals(that.contentType);
    }

    public int hashCode() {
        int result = this.bucketName.hashCode();
        result = 31 * result + this.name.hashCode();
        result = 31 * result + this.createdTime.hashCode();
        result = 31 * result + (int)(this.length ^ this.length >>> 32);
        result = 31 * result + this.etag.hashCode();
        result = 31 * result + this.contentType.hashCode();
        return result;
    }

    public String bucketName() {
        return this.bucketName;
    }

    public String name() {
        return this.name;
    }

    public ZonedDateTime createdTime() {
        return this.createdTime;
    }

    public long length() {
        return this.length;
    }

    public String etag() {
        return this.etag;
    }

    public String contentType() {
        return this.contentType;
    }

    public String toString() {
        return "ObjectStat{bucket='" + this.bucketName + '\'' + ", name='" + this.name + '\'' + ", contentType='" + this.contentType + '\'' + ", createdTime=" + this.createdTime + ", length=" + this.length + ", etag='" + this.etag + '\'' + '}';
    }

    public Map<String, List<String>> httpHeaders() {
        return this.httpHeaders;
    }
}

