/*
 * Decompiled with CFR 0.152.
 */
package io.minio;

import com.google.common.base.Objects;
import io.minio.PutObjectBaseArgs;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;

public class UploadObjectArgs
extends PutObjectBaseArgs {
    private String filename;

    public String filename() {
        return this.filename;
    }

    @Override
    public String contentType() throws IOException {
        String contentType = super.contentType();
        if (contentType != null) {
            return contentType;
        }
        contentType = Files.probeContentType(Paths.get(this.filename, new String[0]));
        return contentType != null && !contentType.isEmpty() ? contentType : "application/octet-stream";
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UploadObjectArgs)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        UploadObjectArgs that = (UploadObjectArgs)o;
        return Objects.equal((Object)this.filename, (Object)that.filename);
    }

    @Override
    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{super.hashCode(), this.filename});
    }

    public static final class Builder
    extends PutObjectBaseArgs.Builder<Builder, UploadObjectArgs> {
        @Override
        protected void validate(UploadObjectArgs args) {
            super.validate(args);
            this.validateFilename(args.filename);
        }

        private void validateFilename(String filename) {
            this.validateNotEmptyString(filename, "filename");
            if (!Files.isRegularFile(Paths.get(filename, new String[0]), new LinkOption[0])) {
                throw new IllegalArgumentException(filename + " not a regular file");
            }
        }

        public Builder filename(String filename) throws IOException {
            this.validateFilename(filename);
            long objectSize = Files.size(Paths.get(filename, new String[0]));
            if (objectSize > 0x50000000000L) {
                throw new IllegalArgumentException("object size " + objectSize + " is not supported; maximum allowed 5TiB");
            }
            double pSize = Math.ceil((double)objectSize / 10000.0);
            pSize = Math.ceil(pSize / 5242880.0) * 5242880.0;
            long partSize = (long)pSize;
            int partCount = pSize > 0.0 ? (int)Math.ceil((double)objectSize / pSize) : 1;
            this.operations.add(args -> ((UploadObjectArgs)args).filename = filename);
            this.operations.add(args -> {
                args.objectSize = objectSize;
            });
            this.operations.add(args -> {
                args.partSize = partSize;
            });
            this.operations.add(args -> {
                args.partCount = partCount;
            });
            return this;
        }

        public Builder contentType(String contentType) {
            this.validateNotEmptyString(contentType, "content type");
            this.operations.add(args -> {
                args.contentType = contentType;
            });
            return this;
        }
    }
}

