/*
 * Decompiled with CFR 0.152.
 */
package reactor.core.publisher;

import java.util.Objects;
import java.util.function.BiFunction;
import org.reactivestreams.Publisher;
import reactor.core.CoreSubscriber;
import reactor.core.Fuseable;
import reactor.core.Scannable;
import reactor.core.publisher.Flux;
import reactor.core.publisher.FluxHide;
import reactor.core.publisher.FluxOperator;

final class FluxLiftFuseable<I, O>
extends FluxOperator<I, O>
implements Fuseable {
    final BiFunction<Scannable, ? super CoreSubscriber<? super O>, ? extends CoreSubscriber<? super I>> lifter;

    FluxLiftFuseable(Publisher<I> p, BiFunction<Scannable, ? super CoreSubscriber<? super O>, ? extends CoreSubscriber<? super I>> lifter) {
        super(Flux.from(p));
        this.lifter = lifter;
    }

    @Override
    public void subscribe(CoreSubscriber<? super O> actual) {
        CoreSubscriber<? super I> input = this.lifter.apply(Scannable.from(this.source), actual);
        Objects.requireNonNull(input, "Lifted subscriber MUST NOT be null");
        if (actual instanceof Fuseable.QueueSubscription && !(input instanceof Fuseable.QueueSubscription)) {
            input = new FluxHide.SuppressFuseableSubscriber<I>(input);
        }
        this.source.subscribe(input);
    }
}

