/*
 * Decompiled with CFR 0.152.
 */
package io.restassured.authentication;

import io.restassured.config.LogConfig;
import io.restassured.filter.log.LogDetail;
import io.restassured.internal.assertion.AssertParameter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class FormAuthConfig {
    private final String formAction;
    private final String userInputTagName;
    private final String passwordInputTagName;
    private final LogConfig logConfig;
    private final LogDetail logDetail;
    private final List<String> additionalInputFieldNames;
    private final String csrfFieldName;
    private final boolean autoDetectCsrfFieldName;
    private final boolean sendCsrfTokenAsFormParam;

    public FormAuthConfig(String formAction, String userNameInputTagName, String passwordInputTagName) {
        this(formAction, userNameInputTagName, passwordInputTagName, null, null, null, false, true, Collections.emptyList());
    }

    public FormAuthConfig() {
        this(null, null, null);
    }

    private FormAuthConfig(String formAction, String userNameInputTagName, String passwordInputTagName, LogDetail logDetail, LogConfig logConfig, String csrfFieldName, boolean autoDetectCsrfFieldName, boolean sendCsrfTokenAsFormParam, List<String> additionalInputFieldNames) {
        this.formAction = formAction;
        this.userInputTagName = userNameInputTagName;
        this.passwordInputTagName = passwordInputTagName;
        this.logDetail = logDetail;
        this.logConfig = logConfig;
        this.csrfFieldName = csrfFieldName;
        this.autoDetectCsrfFieldName = autoDetectCsrfFieldName;
        this.sendCsrfTokenAsFormParam = sendCsrfTokenAsFormParam;
        this.additionalInputFieldNames = Collections.unmodifiableList(additionalInputFieldNames);
    }

    public static FormAuthConfig springSecurity() {
        return new FormAuthConfig("/j_spring_security_check", "j_username", "j_password");
    }

    public FormAuthConfig withCsrfFieldName(String fieldName) {
        AssertParameter.notNull(fieldName, "CSRF field name");
        if (this.autoDetectCsrfFieldName) {
            throw new IllegalStateException("Cannot defined a CSRF field name since the CSRF field name has been marked as auto-detected.");
        }
        return new FormAuthConfig(this.formAction, this.userInputTagName, this.passwordInputTagName, this.logDetail, this.logConfig, fieldName, false, this.sendCsrfTokenAsFormParam, this.additionalInputFieldNames);
    }

    public FormAuthConfig withAdditionalField(String fieldName) {
        AssertParameter.notNull(fieldName, "Additional field name");
        ArrayList<String> list = new ArrayList<String>(this.additionalInputFieldNames);
        list.add(fieldName);
        return new FormAuthConfig(this.formAction, this.userInputTagName, this.passwordInputTagName, this.logDetail, this.logConfig, this.csrfFieldName, this.autoDetectCsrfFieldName, this.sendCsrfTokenAsFormParam, list);
    }

    public FormAuthConfig withAdditionalFields(String firstFieldName, String secondFieldName, String ... additionalFieldNames) {
        AssertParameter.notNull(firstFieldName, "First additional field name");
        AssertParameter.notNull(secondFieldName, "Second additional field name");
        ArrayList<String> list = new ArrayList<String>(this.additionalInputFieldNames);
        list.add(firstFieldName);
        list.add(secondFieldName);
        if (additionalFieldNames != null && additionalFieldNames.length > 0) {
            list.addAll(Arrays.asList(additionalFieldNames));
        }
        return new FormAuthConfig(this.formAction, this.userInputTagName, this.passwordInputTagName, this.logDetail, this.logConfig, this.csrfFieldName, this.autoDetectCsrfFieldName, this.sendCsrfTokenAsFormParam, list);
    }

    public FormAuthConfig sendCsrfTokenAsHeader() {
        return new FormAuthConfig(this.formAction, this.userInputTagName, this.passwordInputTagName, this.logDetail, this.logConfig, this.csrfFieldName, this.autoDetectCsrfFieldName, false, this.additionalInputFieldNames);
    }

    public FormAuthConfig sendCsrfTokenAsFormParam() {
        return new FormAuthConfig(this.formAction, this.userInputTagName, this.passwordInputTagName, this.logDetail, this.logConfig, this.csrfFieldName, this.autoDetectCsrfFieldName, true, this.additionalInputFieldNames);
    }

    public FormAuthConfig withAutoDetectionOfCsrf() {
        if (this.hasCsrfFieldName()) {
            throw new IllegalStateException(String.format("Cannot use auto-detection of CSRF field name since a CSRF field name was already defined as '%s'", this.csrfFieldName));
        }
        return new FormAuthConfig(this.formAction, this.userInputTagName, this.passwordInputTagName, this.logDetail, this.logConfig, this.csrfFieldName, true, this.sendCsrfTokenAsFormParam, this.additionalInputFieldNames);
    }

    public FormAuthConfig withLoggingEnabled() {
        return this.withLoggingEnabled(LogDetail.ALL);
    }

    public FormAuthConfig withLoggingEnabled(LogDetail logDetail) {
        return this.withLoggingEnabled(logDetail, new LogConfig());
    }

    public FormAuthConfig withLoggingEnabled(LogConfig logConfig) {
        return this.withLoggingEnabled(LogDetail.ALL, logConfig);
    }

    public FormAuthConfig withLoggingEnabled(LogDetail logDetail, LogConfig logConfig) {
        AssertParameter.notNull(logDetail, LogDetail.class);
        AssertParameter.notNull(logConfig, LogConfig.class);
        return new FormAuthConfig(this.formAction, this.userInputTagName, this.passwordInputTagName, logDetail, logConfig, this.csrfFieldName, this.autoDetectCsrfFieldName, this.sendCsrfTokenAsFormParam, this.additionalInputFieldNames);
    }

    public static FormAuthConfig formAuthConfig() {
        return new FormAuthConfig(null, null, null);
    }

    public FormAuthConfig and() {
        return this;
    }

    public String getFormAction() {
        return this.formAction;
    }

    public String getUserInputTagName() {
        return this.userInputTagName;
    }

    public String getPasswordInputTagName() {
        return this.passwordInputTagName;
    }

    public LogConfig getLogConfig() {
        return this.logConfig;
    }

    public boolean isLoggingEnabled() {
        return this.logConfig != null && this.logDetail != null;
    }

    public LogDetail getLogDetail() {
        return this.logDetail;
    }

    public String getCsrfFieldName() {
        return this.csrfFieldName;
    }

    public List<String> getAdditionalInputFieldNames() {
        return this.additionalInputFieldNames;
    }

    public boolean hasCsrfFieldName() {
        return StringUtils.isNotBlank((CharSequence)this.csrfFieldName);
    }

    public boolean hasAdditionalInputFieldNames() {
        return !this.additionalInputFieldNames.isEmpty();
    }

    public boolean isAutoDetectCsrfFieldName() {
        return this.autoDetectCsrfFieldName;
    }

    public boolean hasUserInputTagName() {
        return StringUtils.isNotBlank((CharSequence)this.userInputTagName);
    }

    public boolean hasPasswordInputTagName() {
        return StringUtils.isNotBlank((CharSequence)this.passwordInputTagName);
    }

    public boolean hasFormAction() {
        return StringUtils.isNotBlank((CharSequence)this.formAction);
    }

    public boolean requiresParsingOfLoginPage() {
        return !this.hasFormAction() || !this.hasUserInputTagName() || !this.hasPasswordInputTagName() || this.isAutoDetectCsrfFieldName() || this.hasCsrfFieldName() || this.hasAdditionalInputFieldNames();
    }

    public boolean shouldSendCsrfTokenAsFormParam() {
        return this.sendCsrfTokenAsFormParam;
    }
}

