/*
 * Decompiled with CFR 0.152.
 */
package io.restassured.filter.log;

import io.restassured.filter.Filter;
import io.restassured.filter.FilterContext;
import io.restassured.filter.log.LogDetail;
import io.restassured.filter.log.UrlDecoder;
import io.restassured.internal.print.RequestPrinter;
import io.restassured.response.Response;
import io.restassured.specification.FilterableRequestSpecification;
import io.restassured.specification.FilterableResponseSpecification;
import java.io.PrintStream;
import java.nio.charset.Charset;
import org.apache.commons.lang3.Validate;

public class RequestLoggingFilter
implements Filter {
    private static final boolean SHOW_URL_ENCODED_URI = true;
    private final LogDetail logDetail;
    private final PrintStream stream;
    private final boolean shouldPrettyPrint;
    private final boolean showUrlEncodedUri;

    public RequestLoggingFilter() {
        this(LogDetail.ALL, System.out);
    }

    public RequestLoggingFilter(LogDetail logDetail) {
        this(logDetail, System.out);
    }

    public RequestLoggingFilter(PrintStream printStream) {
        this(LogDetail.ALL, printStream);
    }

    public RequestLoggingFilter(LogDetail logDetail, PrintStream stream) {
        this(logDetail, true, stream);
    }

    public RequestLoggingFilter(LogDetail logDetail, boolean shouldPrettyPrint, PrintStream stream) {
        this(logDetail, shouldPrettyPrint, stream, true);
    }

    public RequestLoggingFilter(LogDetail logDetail, boolean shouldPrettyPrint, PrintStream stream, boolean showUrlEncodedUri) {
        Validate.notNull((Object)stream, (String)"Print stream cannot be null", (Object[])new Object[0]);
        Validate.notNull((Object)((Object)logDetail), (String)"Log details cannot be null", (Object[])new Object[0]);
        if (logDetail == LogDetail.STATUS) {
            throw new IllegalArgumentException(String.format("%s is not a valid %s for a request.", new Object[]{LogDetail.STATUS, LogDetail.class.getSimpleName()}));
        }
        this.stream = stream;
        this.logDetail = logDetail;
        this.shouldPrettyPrint = shouldPrettyPrint;
        this.showUrlEncodedUri = showUrlEncodedUri;
    }

    @Override
    public Response filter(FilterableRequestSpecification requestSpec, FilterableResponseSpecification responseSpec, FilterContext ctx) {
        String uri = requestSpec.getURI();
        if (!this.showUrlEncodedUri) {
            uri = UrlDecoder.urlDecode(uri, Charset.forName(requestSpec.getConfig().getEncoderConfig().defaultQueryParameterCharset()), true);
        }
        RequestPrinter.print(requestSpec, requestSpec.getMethod(), uri, this.logDetail, this.stream, this.shouldPrettyPrint);
        return ctx.next(requestSpec, responseSpec);
    }

    public static RequestLoggingFilter logRequestTo(PrintStream stream) {
        return new RequestLoggingFilter(stream);
    }
}

