/*
 * Decompiled with CFR 0.152.
 */
package io.restassured.http;

import io.restassured.internal.http.ContentTypeExtractor;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Iterator;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;

public enum ContentType {
    ANY("*/*"),
    TEXT("text/plain"),
    JSON("application/json", "application/javascript", "text/javascript", "text/json"),
    XML("application/xml", "text/xml", "application/xhtml+xml"),
    HTML("text/html"),
    URLENC("application/x-www-form-urlencoded"),
    BINARY("application/octet-stream");

    private static final String PLUS_XML = "+xml";
    private static final String PLUS_JSON = "+json";
    private static final String PLUS_HTML = "+html";
    private final String[] ctStrings;

    public String[] getContentTypeStrings() {
        return this.ctStrings;
    }

    public String toString() {
        return this.ctStrings[0];
    }

    public String getAcceptHeader() {
        Iterator<String> iter = Arrays.asList(this.ctStrings).iterator();
        StringBuilder sb = new StringBuilder();
        while (iter.hasNext()) {
            sb.append(iter.next());
            if (!iter.hasNext()) continue;
            sb.append(", ");
        }
        return sb.toString();
    }

    public String withCharset(Charset charset) {
        if (charset == null) {
            throw new IllegalArgumentException("charset cannot be null");
        }
        return this.withCharset(charset.toString());
    }

    public String withCharset(String charset) {
        if (StringUtils.isBlank((CharSequence)charset)) {
            throw new IllegalArgumentException("charset cannot be empty");
        }
        return String.format("%s; charset=%s", this.toString(), StringUtils.trim((String)charset));
    }

    private ContentType(String ... contentTypes) {
        this.ctStrings = contentTypes;
    }

    public static ContentType fromContentType(String contentType) {
        if (contentType == null) {
            return null;
        }
        ContentType foundContentType = ArrayUtils.contains((Object[])ContentType.XML.ctStrings, (Object)(contentType = ContentTypeExtractor.getContentTypeWithoutCharset(contentType.toLowerCase()))) || StringUtils.endsWithIgnoreCase((CharSequence)contentType, (CharSequence)PLUS_XML) ? XML : (ArrayUtils.contains((Object[])ContentType.JSON.ctStrings, (Object)contentType) || StringUtils.endsWithIgnoreCase((CharSequence)contentType, (CharSequence)PLUS_JSON) ? JSON : (ArrayUtils.contains((Object[])ContentType.TEXT.ctStrings, (Object)contentType) ? TEXT : (ArrayUtils.contains((Object[])ContentType.HTML.ctStrings, (Object)contentType) || StringUtils.endsWithIgnoreCase((CharSequence)contentType, (CharSequence)PLUS_HTML) ? HTML : (ArrayUtils.contains((Object[])ContentType.URLENC.ctStrings, (Object)contentType) ? URLENC : (ArrayUtils.contains((Object[])ContentType.BINARY.ctStrings, (Object)contentType) ? BINARY : (ArrayUtils.contains((Object[])ContentType.ANY.ctStrings, (Object)contentType) ? ANY : null))))));
        return foundContentType;
    }

    public boolean matches(String contentType) {
        String expectedContentType = StringUtils.trimToNull((String)contentType);
        if (expectedContentType == null) {
            return false;
        }
        for (String supportedContentType : this.getContentTypeStrings()) {
            if (!supportedContentType.equalsIgnoreCase(expectedContentType)) continue;
            return true;
        }
        return false;
    }
}

