/*
 * Decompiled with CFR 0.152.
 */
package io.seata.core.rpc.netty;

import io.netty.channel.Channel;
import io.seata.core.rpc.TransactionMessageHandler;
import io.seata.core.rpc.netty.AbstractNettyRemotingServer;
import io.seata.core.rpc.netty.NettyServerConfig;
import io.seata.core.rpc.processor.server.RegRmProcessor;
import io.seata.core.rpc.processor.server.RegTmProcessor;
import io.seata.core.rpc.processor.server.ServerHeartbeatProcessor;
import io.seata.core.rpc.processor.server.ServerOnRequestProcessor;
import io.seata.core.rpc.processor.server.ServerOnResponseProcessor;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NettyRemotingServer
extends AbstractNettyRemotingServer {
    private static final Logger LOGGER = LoggerFactory.getLogger(NettyRemotingServer.class);
    private TransactionMessageHandler transactionMessageHandler;
    private final AtomicBoolean initialized = new AtomicBoolean(false);

    @Override
    public void init() {
        this.registerProcessor();
        if (this.initialized.compareAndSet(false, true)) {
            super.init();
        }
    }

    public NettyRemotingServer(ThreadPoolExecutor messageExecutor) {
        super(messageExecutor, new NettyServerConfig());
    }

    public void setHandler(TransactionMessageHandler transactionMessageHandler) {
        this.transactionMessageHandler = transactionMessageHandler;
    }

    public TransactionMessageHandler getHandler() {
        return this.transactionMessageHandler;
    }

    @Override
    public void destroyChannel(String serverAddress, Channel channel) {
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("will destroy channel:{},address:{}", (Object)channel, (Object)serverAddress);
        }
        channel.disconnect();
        channel.close();
    }

    private void registerProcessor() {
        ServerOnRequestProcessor onRequestProcessor = new ServerOnRequestProcessor(this, this.getHandler());
        super.registerProcessor(11, onRequestProcessor, this.messageExecutor);
        super.registerProcessor(13, onRequestProcessor, this.messageExecutor);
        super.registerProcessor(1, onRequestProcessor, this.messageExecutor);
        super.registerProcessor(7, onRequestProcessor, this.messageExecutor);
        super.registerProcessor(21, onRequestProcessor, this.messageExecutor);
        super.registerProcessor(17, onRequestProcessor, this.messageExecutor);
        super.registerProcessor(9, onRequestProcessor, this.messageExecutor);
        super.registerProcessor(15, onRequestProcessor, this.messageExecutor);
        super.registerProcessor(59, onRequestProcessor, this.messageExecutor);
        ServerOnResponseProcessor onResponseProcessor = new ServerOnResponseProcessor(this.getHandler(), this.getFutures());
        super.registerProcessor(4, onResponseProcessor, this.messageExecutor);
        super.registerProcessor(6, onResponseProcessor, this.messageExecutor);
        RegRmProcessor regRmProcessor = new RegRmProcessor(this);
        super.registerProcessor(103, regRmProcessor, this.messageExecutor);
        RegTmProcessor regTmProcessor = new RegTmProcessor(this);
        super.registerProcessor(101, regTmProcessor, null);
        ServerHeartbeatProcessor heartbeatMessageProcessor = new ServerHeartbeatProcessor(this);
        super.registerProcessor(120, heartbeatMessageProcessor, null);
    }
}

