/*
 * Decompiled with CFR 0.152.
 */
package io.shardingjdbc.core.api.config;

import com.google.common.base.Preconditions;
import io.shardingjdbc.core.api.MasterSlaveDataSourceFactory;
import io.shardingjdbc.core.api.config.MasterSlaveRuleConfiguration;
import io.shardingjdbc.core.api.config.TableRuleConfiguration;
import io.shardingjdbc.core.api.config.strategy.ShardingStrategyConfiguration;
import io.shardingjdbc.core.keygen.DefaultKeyGenerator;
import io.shardingjdbc.core.keygen.KeyGenerator;
import io.shardingjdbc.core.keygen.KeyGeneratorFactory;
import io.shardingjdbc.core.routing.strategy.ShardingStrategy;
import io.shardingjdbc.core.rule.ShardingRule;
import io.shardingjdbc.core.rule.TableRule;
import java.sql.SQLException;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Map;
import javax.sql.DataSource;

public class ShardingRuleConfiguration {
    private String defaultDataSourceName;
    private Collection<TableRuleConfiguration> tableRuleConfigs = new LinkedList<TableRuleConfiguration>();
    private Collection<String> bindingTableGroups = new LinkedList<String>();
    private ShardingStrategyConfiguration defaultDatabaseShardingStrategyConfig;
    private ShardingStrategyConfiguration defaultTableShardingStrategyConfig;
    private String defaultKeyGeneratorClass;
    private Collection<MasterSlaveRuleConfiguration> masterSlaveRuleConfigs = new LinkedList<MasterSlaveRuleConfiguration>();

    public ShardingRule build(Map<String, DataSource> dataSourceMap) throws SQLException {
        Preconditions.checkNotNull(dataSourceMap, (Object)"dataSources cannot be null.");
        Preconditions.checkArgument((!dataSourceMap.isEmpty() ? 1 : 0) != 0, (Object)"dataSources cannot be null.");
        this.processDataSourceMapWithMasterSlave(dataSourceMap);
        LinkedList<TableRule> tableRules = new LinkedList<TableRule>();
        for (TableRuleConfiguration each : this.tableRuleConfigs) {
            tableRules.add(each.build(dataSourceMap));
        }
        ShardingStrategy defaultDatabaseShardingStrategy = null == this.defaultDatabaseShardingStrategyConfig ? null : this.defaultDatabaseShardingStrategyConfig.build();
        ShardingStrategy defaultTableShardingStrategy = null == this.defaultTableShardingStrategyConfig ? null : this.defaultTableShardingStrategyConfig.build();
        KeyGenerator keyGenerator = KeyGeneratorFactory.newInstance(null == this.defaultKeyGeneratorClass ? DefaultKeyGenerator.class.getName() : this.defaultKeyGeneratorClass);
        return new ShardingRule(dataSourceMap, this.defaultDataSourceName, tableRules, this.bindingTableGroups, defaultDatabaseShardingStrategy, defaultTableShardingStrategy, keyGenerator);
    }

    private void processDataSourceMapWithMasterSlave(Map<String, DataSource> dataSourceMap) throws SQLException {
        for (MasterSlaveRuleConfiguration each : this.masterSlaveRuleConfigs) {
            dataSourceMap.put(each.getName(), MasterSlaveDataSourceFactory.createDataSource(dataSourceMap, each));
            dataSourceMap.remove(each.getMasterDataSourceName());
            for (String slaveDataSourceName : each.getSlaveDataSourceNames()) {
                dataSourceMap.remove(slaveDataSourceName);
            }
        }
    }

    public String getDefaultDataSourceName() {
        return this.defaultDataSourceName;
    }

    public Collection<TableRuleConfiguration> getTableRuleConfigs() {
        return this.tableRuleConfigs;
    }

    public Collection<String> getBindingTableGroups() {
        return this.bindingTableGroups;
    }

    public ShardingStrategyConfiguration getDefaultDatabaseShardingStrategyConfig() {
        return this.defaultDatabaseShardingStrategyConfig;
    }

    public ShardingStrategyConfiguration getDefaultTableShardingStrategyConfig() {
        return this.defaultTableShardingStrategyConfig;
    }

    public String getDefaultKeyGeneratorClass() {
        return this.defaultKeyGeneratorClass;
    }

    public Collection<MasterSlaveRuleConfiguration> getMasterSlaveRuleConfigs() {
        return this.masterSlaveRuleConfigs;
    }

    public void setDefaultDataSourceName(String defaultDataSourceName) {
        this.defaultDataSourceName = defaultDataSourceName;
    }

    public void setTableRuleConfigs(Collection<TableRuleConfiguration> tableRuleConfigs) {
        this.tableRuleConfigs = tableRuleConfigs;
    }

    public void setBindingTableGroups(Collection<String> bindingTableGroups) {
        this.bindingTableGroups = bindingTableGroups;
    }

    public void setDefaultDatabaseShardingStrategyConfig(ShardingStrategyConfiguration defaultDatabaseShardingStrategyConfig) {
        this.defaultDatabaseShardingStrategyConfig = defaultDatabaseShardingStrategyConfig;
    }

    public void setDefaultTableShardingStrategyConfig(ShardingStrategyConfiguration defaultTableShardingStrategyConfig) {
        this.defaultTableShardingStrategyConfig = defaultTableShardingStrategyConfig;
    }

    public void setDefaultKeyGeneratorClass(String defaultKeyGeneratorClass) {
        this.defaultKeyGeneratorClass = defaultKeyGeneratorClass;
    }

    public void setMasterSlaveRuleConfigs(Collection<MasterSlaveRuleConfiguration> masterSlaveRuleConfigs) {
        this.masterSlaveRuleConfigs = masterSlaveRuleConfigs;
    }
}

