/*
 * Decompiled with CFR 0.152.
 */
package io.shardingjdbc.core.api.config.strategy;

import com.google.common.base.Preconditions;
import io.shardingjdbc.core.api.algorithm.sharding.complex.ComplexKeysShardingAlgorithm;
import io.shardingjdbc.core.api.config.strategy.ShardingStrategyConfiguration;
import io.shardingjdbc.core.routing.strategy.ShardingAlgorithmFactory;
import io.shardingjdbc.core.routing.strategy.ShardingStrategy;
import io.shardingjdbc.core.routing.strategy.complex.ComplexShardingStrategy;
import io.shardingjdbc.core.util.StringUtil;
import java.beans.ConstructorProperties;

public final class ComplexShardingStrategyConfiguration
implements ShardingStrategyConfiguration {
    private final String shardingColumns;
    private final String algorithmClassName;

    @Override
    public ShardingStrategy build() {
        Preconditions.checkNotNull((Object)this.shardingColumns, (Object)"Sharding columns cannot be null.");
        Preconditions.checkNotNull((Object)this.algorithmClassName, (Object)"Algorithm class cannot be null.");
        return new ComplexShardingStrategy(StringUtil.splitWithComma(this.shardingColumns), ShardingAlgorithmFactory.newInstance(this.algorithmClassName, ComplexKeysShardingAlgorithm.class));
    }

    @ConstructorProperties(value={"shardingColumns", "algorithmClassName"})
    public ComplexShardingStrategyConfiguration(String shardingColumns, String algorithmClassName) {
        this.shardingColumns = shardingColumns;
        this.algorithmClassName = algorithmClassName;
    }

    public String getShardingColumns() {
        return this.shardingColumns;
    }

    public String getAlgorithmClassName() {
        return this.algorithmClassName;
    }
}

