/*
 * Decompiled with CFR 0.152.
 */
package io.shardingjdbc.core.executor.event;

import com.google.common.base.Optional;
import io.shardingjdbc.core.executor.event.EventExecutionType;
import java.sql.SQLException;
import java.util.List;
import java.util.UUID;

public abstract class AbstractExecutionEvent {
    private final String id = UUID.randomUUID().toString();
    private final String dataSource;
    private final String sql;
    private final List<Object> parameters;
    private EventExecutionType eventExecutionType;
    private Optional<SQLException> exception;

    public AbstractExecutionEvent(String dataSource, String sql, List<Object> parameters) {
        this.dataSource = dataSource;
        this.sql = sql;
        this.parameters = parameters;
        this.eventExecutionType = EventExecutionType.BEFORE_EXECUTE;
    }

    public String getId() {
        return this.id;
    }

    public String getDataSource() {
        return this.dataSource;
    }

    public String getSql() {
        return this.sql;
    }

    public List<Object> getParameters() {
        return this.parameters;
    }

    public EventExecutionType getEventExecutionType() {
        return this.eventExecutionType;
    }

    public Optional<SQLException> getException() {
        return this.exception;
    }

    public void setEventExecutionType(EventExecutionType eventExecutionType) {
        this.eventExecutionType = eventExecutionType;
    }

    public void setException(Optional<SQLException> exception) {
        this.exception = exception;
    }
}

