/*
 * Decompiled with CFR 0.152.
 */
package io.shardingjdbc.core.jdbc.core.connection;

import com.google.common.base.Preconditions;
import io.shardingjdbc.core.constant.SQLType;
import io.shardingjdbc.core.hint.HintManagerHolder;
import io.shardingjdbc.core.jdbc.adapter.AbstractConnectionAdapter;
import io.shardingjdbc.core.jdbc.core.ShardingContext;
import io.shardingjdbc.core.jdbc.core.datasource.MasterSlaveDataSource;
import io.shardingjdbc.core.jdbc.core.datasource.NamedDataSource;
import io.shardingjdbc.core.jdbc.core.statement.ShardingPreparedStatement;
import io.shardingjdbc.core.jdbc.core.statement.ShardingStatement;
import java.beans.ConstructorProperties;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import javax.sql.DataSource;

public final class ShardingConnection
extends AbstractConnectionAdapter {
    private final ShardingContext shardingContext;

    public Collection<Connection> getAllConnections(String dataSourceName) throws SQLException {
        Map<String, DataSource> dataSources;
        DataSource dataSource = this.shardingContext.getShardingRule().getDataSourceMap().get(dataSourceName);
        Preconditions.checkState((null != dataSource ? 1 : 0) != 0, (String)"Missing the rule of %s in DataSourceRule", (Object[])new Object[]{dataSourceName});
        if (dataSource instanceof MasterSlaveDataSource) {
            dataSources = ((MasterSlaveDataSource)dataSource).getAllDataSources();
        } else {
            dataSources = new HashMap<String, DataSource>(1, 1.0f);
            dataSources.put(dataSourceName, dataSource);
        }
        LinkedList<Connection> result = new LinkedList<Connection>();
        for (Map.Entry<String, DataSource> entry : dataSources.entrySet()) {
            Connection connection = entry.getValue().getConnection();
            this.replayMethodsInvocation(connection);
            this.getCachedConnections().put(entry.getKey(), connection);
            result.add(connection);
        }
        return result;
    }

    public Connection getConnection(String dataSourceName, SQLType sqlType) throws SQLException {
        String realDataSourceName;
        if (this.getCachedConnections().containsKey(dataSourceName)) {
            return this.getCachedConnections().get(dataSourceName);
        }
        DataSource dataSource = this.shardingContext.getShardingRule().getDataSourceMap().get(dataSourceName);
        Preconditions.checkState((null != dataSource ? 1 : 0) != 0, (String)"Missing the rule of %s in DataSourceRule", (Object[])new Object[]{dataSourceName});
        if (dataSource instanceof MasterSlaveDataSource) {
            NamedDataSource namedDataSource = ((MasterSlaveDataSource)dataSource).getDataSource(sqlType);
            realDataSourceName = namedDataSource.getName();
            if (this.getCachedConnections().containsKey(realDataSourceName)) {
                return this.getCachedConnections().get(realDataSourceName);
            }
            dataSource = namedDataSource.getDataSource();
        } else {
            realDataSourceName = dataSourceName;
        }
        Connection result = dataSource.getConnection();
        this.getCachedConnections().put(realDataSourceName, result);
        this.replayMethodsInvocation(result);
        return result;
    }

    public void release(Connection connection) {
        this.getCachedConnections().values().remove(connection);
        try {
            connection.close();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    @Override
    public DatabaseMetaData getMetaData() throws SQLException {
        return this.getConnection(this.shardingContext.getShardingRule().getDataSourceMap().keySet().iterator().next(), SQLType.DQL).getMetaData();
    }

    @Override
    public PreparedStatement prepareStatement(String sql) throws SQLException {
        return new ShardingPreparedStatement(this, sql);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        return new ShardingPreparedStatement(this, sql, resultSetType, resultSetConcurrency);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        return new ShardingPreparedStatement(this, sql, resultSetType, resultSetConcurrency, resultSetHoldability);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        return new ShardingPreparedStatement(this, sql, autoGeneratedKeys);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        return new ShardingPreparedStatement(this, sql, 1);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        return new ShardingPreparedStatement(this, sql, 1);
    }

    @Override
    public Statement createStatement() throws SQLException {
        return new ShardingStatement(this);
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        return new ShardingStatement(this, resultSetType, resultSetConcurrency);
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        return new ShardingStatement(this, resultSetType, resultSetConcurrency, resultSetHoldability);
    }

    @Override
    public void close() throws SQLException {
        HintManagerHolder.clear();
        MasterSlaveDataSource.resetDMLFlag();
        super.close();
    }

    @ConstructorProperties(value={"shardingContext"})
    public ShardingConnection(ShardingContext shardingContext) {
        this.shardingContext = shardingContext;
    }

    public ShardingContext getShardingContext() {
        return this.shardingContext;
    }
}

