/*
 * Decompiled with CFR 0.152.
 */
package io.shardingjdbc.core.parsing.lexer;

import io.shardingjdbc.core.constant.DatabaseType;
import io.shardingjdbc.core.parsing.lexer.LexerEngine;
import io.shardingjdbc.core.parsing.lexer.dialect.mysql.MySQLLexer;
import io.shardingjdbc.core.parsing.lexer.dialect.oracle.OracleLexer;
import io.shardingjdbc.core.parsing.lexer.dialect.postgresql.PostgreSQLLexer;
import io.shardingjdbc.core.parsing.lexer.dialect.sqlserver.SQLServerLexer;

public final class LexerEngineFactory {
    public static LexerEngine newInstance(DatabaseType dbType, String sql) {
        switch (dbType) {
            case H2: 
            case MySQL: {
                return new LexerEngine(new MySQLLexer(sql));
            }
            case Oracle: {
                return new LexerEngine(new OracleLexer(sql));
            }
            case SQLServer: {
                return new LexerEngine(new SQLServerLexer(sql));
            }
            case PostgreSQL: {
                return new LexerEngine(new PostgreSQLLexer(sql));
            }
        }
        throw new UnsupportedOperationException(String.format("Cannot support database [%s].", new Object[]{dbType}));
    }

    private LexerEngineFactory() {
    }
}

