/*
 * Decompiled with CFR 0.152.
 */
package io.shardingjdbc.core.parsing.parser.clause;

import com.google.common.base.Optional;
import io.shardingjdbc.core.parsing.lexer.LexerEngine;
import io.shardingjdbc.core.parsing.lexer.token.DefaultKeyword;
import io.shardingjdbc.core.parsing.lexer.token.Keyword;
import io.shardingjdbc.core.parsing.lexer.token.Symbol;
import io.shardingjdbc.core.parsing.lexer.token.TokenType;
import io.shardingjdbc.core.parsing.parser.clause.AliasClauseParser;
import io.shardingjdbc.core.parsing.parser.clause.ExpressionClauseParser;
import io.shardingjdbc.core.parsing.parser.clause.SQLClauseParser;
import io.shardingjdbc.core.parsing.parser.context.table.Table;
import io.shardingjdbc.core.parsing.parser.sql.SQLStatement;
import io.shardingjdbc.core.parsing.parser.token.TableToken;
import io.shardingjdbc.core.rule.ShardingRule;
import io.shardingjdbc.core.util.SQLUtil;
import java.util.Arrays;
import java.util.LinkedList;

public class TableReferencesClauseParser
implements SQLClauseParser {
    private final ShardingRule shardingRule;
    private final LexerEngine lexerEngine;
    private final AliasClauseParser aliasClauseParser;
    private final ExpressionClauseParser expressionClauseParser;

    public TableReferencesClauseParser(ShardingRule shardingRule, LexerEngine lexerEngine) {
        this.shardingRule = shardingRule;
        this.lexerEngine = lexerEngine;
        this.aliasClauseParser = new AliasClauseParser(lexerEngine);
        this.expressionClauseParser = new ExpressionClauseParser(lexerEngine);
    }

    public final void parse(SQLStatement sqlStatement, boolean isSingleTableOnly) {
        do {
            this.parseTableReference(sqlStatement, isSingleTableOnly);
        } while (this.lexerEngine.skipIfEqual(Symbol.COMMA));
    }

    protected void parseTableReference(SQLStatement sqlStatement, boolean isSingleTableOnly) {
        this.parseTableFactor(sqlStatement, isSingleTableOnly);
    }

    protected final void parseTableFactor(SQLStatement sqlStatement, boolean isSingleTableOnly) {
        int beginPosition = this.lexerEngine.getCurrentToken().getEndPosition() - this.lexerEngine.getCurrentToken().getLiterals().length();
        String literals = this.lexerEngine.getCurrentToken().getLiterals();
        this.lexerEngine.nextToken();
        if (this.lexerEngine.equalAny(Symbol.DOT)) {
            throw new UnsupportedOperationException("Cannot support SQL for `schema.table`");
        }
        String tableName = SQLUtil.getExactlyValue(literals);
        Optional<String> alias = this.aliasClauseParser.parse();
        if (isSingleTableOnly || this.shardingRule.tryFindTableRule(tableName).isPresent() || this.shardingRule.findBindingTableRule(tableName).isPresent() || this.shardingRule.getDataSourceMap().containsKey(this.shardingRule.getDefaultDataSourceName())) {
            sqlStatement.getSqlTokens().add(new TableToken(beginPosition, literals));
            sqlStatement.getTables().add(new Table(tableName, alias));
        }
        this.parseJoinTable(sqlStatement);
        if (isSingleTableOnly && !sqlStatement.getTables().isSingleTable()) {
            throw new UnsupportedOperationException("Cannot support Multiple-Table.");
        }
    }

    private void parseJoinTable(SQLStatement sqlStatement) {
        while (this.parseJoinType()) {
            if (this.lexerEngine.equalAny(Symbol.LEFT_PAREN)) {
                throw new UnsupportedOperationException("Cannot support sub query for join table.");
            }
            this.parseTableFactor(sqlStatement, false);
            this.parseJoinCondition(sqlStatement);
        }
    }

    private boolean parseJoinType() {
        LinkedList<Keyword> joinTypeKeywords = new LinkedList<Keyword>();
        joinTypeKeywords.addAll(Arrays.asList(DefaultKeyword.INNER, DefaultKeyword.OUTER, DefaultKeyword.LEFT, DefaultKeyword.RIGHT, DefaultKeyword.FULL, DefaultKeyword.CROSS, DefaultKeyword.NATURAL, DefaultKeyword.JOIN));
        joinTypeKeywords.addAll(Arrays.asList(this.getKeywordsForJoinType()));
        TokenType[] joinTypeKeywordArrays = joinTypeKeywords.toArray(new Keyword[joinTypeKeywords.size()]);
        if (!this.lexerEngine.equalAny(joinTypeKeywordArrays)) {
            return false;
        }
        this.lexerEngine.skipAll(joinTypeKeywordArrays);
        return true;
    }

    protected Keyword[] getKeywordsForJoinType() {
        return new Keyword[0];
    }

    private void parseJoinCondition(SQLStatement sqlStatement) {
        if (this.lexerEngine.skipIfEqual(DefaultKeyword.ON)) {
            do {
                this.expressionClauseParser.parse(sqlStatement);
                this.lexerEngine.accept(Symbol.EQ);
                this.expressionClauseParser.parse(sqlStatement);
            } while (this.lexerEngine.skipIfEqual(DefaultKeyword.AND));
        } else if (this.lexerEngine.skipIfEqual(DefaultKeyword.USING)) {
            this.lexerEngine.skipParentheses(sqlStatement);
        }
    }

    public LexerEngine getLexerEngine() {
        return this.lexerEngine;
    }
}

