/*
 * Decompiled with CFR 0.152.
 */
package io.shardingjdbc.core.parsing.parser.context.limit;

import io.shardingjdbc.core.parsing.parser.context.limit.LimitValue;
import io.shardingjdbc.core.parsing.parser.exception.SQLParsingException;
import io.shardingjdbc.core.util.NumberUtil;
import java.beans.ConstructorProperties;
import java.util.List;

public final class Limit {
    private final boolean rowCountRewriteFlag;
    private LimitValue offset;
    private LimitValue rowCount;

    public int getOffsetValue() {
        return null != this.offset ? this.offset.getValue() : 0;
    }

    public int getRowCountValue() {
        return null != this.rowCount ? this.rowCount.getValue() : -1;
    }

    public void processParameters(List<Object> parameters, boolean isFetchAll) {
        this.fill(parameters);
        this.rewrite(parameters, isFetchAll);
    }

    private void fill(List<Object> parameters) {
        int offset = 0;
        if (null != this.offset) {
            offset = -1 == this.offset.getIndex() ? this.getOffsetValue() : NumberUtil.roundHalfUp(parameters.get(this.offset.getIndex()));
            this.offset.setValue(offset);
        }
        int rowCount = 0;
        if (null != this.rowCount) {
            rowCount = -1 == this.rowCount.getIndex() ? this.getRowCountValue() : NumberUtil.roundHalfUp(parameters.get(this.rowCount.getIndex()));
            this.rowCount.setValue(rowCount);
        }
        if (offset < 0 || rowCount < 0) {
            throw new SQLParsingException("LIMIT offset and row count can not be a negative value.", new Object[0]);
        }
    }

    private void rewrite(List<Object> parameters, boolean isFetchAll) {
        int rewriteOffset = 0;
        int rewriteRowCount = isFetchAll ? Integer.MAX_VALUE : (this.rowCountRewriteFlag ? (null == this.rowCount ? -1 : this.getOffsetValue() + this.rowCount.getValue()) : this.rowCount.getValue());
        if (null != this.offset && this.offset.getIndex() > -1) {
            parameters.set(this.offset.getIndex(), rewriteOffset);
        }
        if (null != this.rowCount && this.rowCount.getIndex() > -1) {
            parameters.set(this.rowCount.getIndex(), rewriteRowCount);
        }
    }

    @ConstructorProperties(value={"rowCountRewriteFlag"})
    public Limit(boolean rowCountRewriteFlag) {
        this.rowCountRewriteFlag = rowCountRewriteFlag;
    }

    public boolean isRowCountRewriteFlag() {
        return this.rowCountRewriteFlag;
    }

    public LimitValue getOffset() {
        return this.offset;
    }

    public LimitValue getRowCount() {
        return this.rowCount;
    }

    public void setOffset(LimitValue offset) {
        this.offset = offset;
    }

    public void setRowCount(LimitValue rowCount) {
        this.rowCount = rowCount;
    }

    public String toString() {
        return "Limit(rowCountRewriteFlag=" + this.isRowCountRewriteFlag() + ", offset=" + this.getOffset() + ", rowCount=" + this.getRowCount() + ")";
    }
}

