/*
 * Decompiled with CFR 0.152.
 */
package io.shardingjdbc.core.rewrite;

import com.google.common.base.Optional;
import io.shardingjdbc.core.parsing.lexer.token.DefaultKeyword;
import io.shardingjdbc.core.parsing.parser.context.OrderItem;
import io.shardingjdbc.core.parsing.parser.context.limit.Limit;
import io.shardingjdbc.core.parsing.parser.sql.SQLStatement;
import io.shardingjdbc.core.parsing.parser.sql.dql.select.SelectStatement;
import io.shardingjdbc.core.parsing.parser.token.ItemsToken;
import io.shardingjdbc.core.parsing.parser.token.OffsetToken;
import io.shardingjdbc.core.parsing.parser.token.OrderByToken;
import io.shardingjdbc.core.parsing.parser.token.RowCountToken;
import io.shardingjdbc.core.parsing.parser.token.SQLToken;
import io.shardingjdbc.core.parsing.parser.token.TableToken;
import io.shardingjdbc.core.rewrite.SQLBuilder;
import io.shardingjdbc.core.routing.type.TableUnit;
import io.shardingjdbc.core.routing.type.complex.CartesianTableReference;
import io.shardingjdbc.core.rule.BindingTableRule;
import io.shardingjdbc.core.rule.ShardingRule;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public final class SQLRewriteEngine {
    private final ShardingRule shardingRule;
    private final String originalSQL;
    private final List<SQLToken> sqlTokens = new LinkedList<SQLToken>();
    private final SQLStatement sqlStatement;

    public SQLRewriteEngine(ShardingRule shardingRule, String originalSQL, SQLStatement sqlStatement) {
        this.shardingRule = shardingRule;
        this.originalSQL = originalSQL;
        this.sqlStatement = sqlStatement;
        this.sqlTokens.addAll(sqlStatement.getSqlTokens());
    }

    public SQLBuilder rewrite(boolean isRewriteLimit) {
        SQLBuilder result = new SQLBuilder();
        if (this.sqlTokens.isEmpty()) {
            result.appendLiterals(this.originalSQL);
            return result;
        }
        int count = 0;
        this.sortByBeginPosition();
        for (SQLToken each : this.sqlTokens) {
            if (0 == count) {
                result.appendLiterals(this.originalSQL.substring(0, each.getBeginPosition()));
            }
            if (each instanceof TableToken) {
                this.appendTableToken(result, (TableToken)each, count, this.sqlTokens);
            } else if (each instanceof ItemsToken) {
                this.appendItemsToken(result, (ItemsToken)each, count, this.sqlTokens);
            } else if (each instanceof RowCountToken) {
                this.appendLimitRowCount(result, (RowCountToken)each, count, this.sqlTokens, isRewriteLimit);
            } else if (each instanceof OffsetToken) {
                this.appendLimitOffsetToken(result, (OffsetToken)each, count, this.sqlTokens, isRewriteLimit);
            } else if (each instanceof OrderByToken) {
                this.appendOrderByToken(result, count, this.sqlTokens);
            }
            ++count;
        }
        return result;
    }

    private void sortByBeginPosition() {
        Collections.sort(this.sqlTokens, new Comparator<SQLToken>(){

            @Override
            public int compare(SQLToken o1, SQLToken o2) {
                return o1.getBeginPosition() - o2.getBeginPosition();
            }
        });
    }

    private void appendTableToken(SQLBuilder sqlBuilder, TableToken tableToken, int count, List<SQLToken> sqlTokens) {
        String tableName = this.sqlStatement.getTables().getTableNames().contains(tableToken.getTableName()) ? tableToken.getTableName() : tableToken.getOriginalLiterals();
        sqlBuilder.appendTable(tableName);
        int beginPosition = tableToken.getBeginPosition() + tableToken.getOriginalLiterals().length();
        this.appendRest(sqlBuilder, count, sqlTokens, beginPosition);
    }

    private void appendItemsToken(SQLBuilder sqlBuilder, ItemsToken itemsToken, int count, List<SQLToken> sqlTokens) {
        for (String item : itemsToken.getItems()) {
            sqlBuilder.appendLiterals(", ");
            sqlBuilder.appendLiterals(item);
        }
        int beginPosition = itemsToken.getBeginPosition();
        this.appendRest(sqlBuilder, count, sqlTokens, beginPosition);
    }

    private void appendLimitRowCount(SQLBuilder sqlBuilder, RowCountToken rowCountToken, int count, List<SQLToken> sqlTokens, boolean isRewrite) {
        SelectStatement selectStatement = (SelectStatement)this.sqlStatement;
        Limit limit = selectStatement.getLimit();
        if (!isRewrite) {
            sqlBuilder.appendLiterals(String.valueOf(rowCountToken.getRowCount()));
        } else if (!(selectStatement.getGroupByItems().isEmpty() && selectStatement.getAggregationSelectItems().isEmpty() || selectStatement.isSameGroupByAndOrderByItems())) {
            sqlBuilder.appendLiterals(String.valueOf(Integer.MAX_VALUE));
        } else {
            sqlBuilder.appendLiterals(String.valueOf(limit.isRowCountRewriteFlag() ? rowCountToken.getRowCount() + limit.getOffsetValue() : rowCountToken.getRowCount()));
        }
        int beginPosition = rowCountToken.getBeginPosition() + String.valueOf(rowCountToken.getRowCount()).length();
        this.appendRest(sqlBuilder, count, sqlTokens, beginPosition);
    }

    private void appendLimitOffsetToken(SQLBuilder sqlBuilder, OffsetToken offsetToken, int count, List<SQLToken> sqlTokens, boolean isRewrite) {
        sqlBuilder.appendLiterals(isRewrite ? "0" : String.valueOf(offsetToken.getOffset()));
        int beginPosition = offsetToken.getBeginPosition() + String.valueOf(offsetToken.getOffset()).length();
        this.appendRest(sqlBuilder, count, sqlTokens, beginPosition);
    }

    private void appendOrderByToken(SQLBuilder sqlBuilder, int count, List<SQLToken> sqlTokens) {
        SelectStatement selectStatement = (SelectStatement)this.sqlStatement;
        StringBuilder orderByLiterals = new StringBuilder();
        orderByLiterals.append(" ").append(DefaultKeyword.ORDER).append(" ").append(DefaultKeyword.BY).append(" ");
        int i = 0;
        for (OrderItem each : selectStatement.getOrderByItems()) {
            if (0 == i) {
                orderByLiterals.append(each.getColumnLabel()).append(" ").append(each.getType().name());
            } else {
                orderByLiterals.append(",").append(each.getColumnLabel()).append(" ").append(each.getType().name());
            }
            ++i;
        }
        orderByLiterals.append(" ");
        sqlBuilder.appendLiterals(orderByLiterals.toString());
        int beginPosition = ((SelectStatement)this.sqlStatement).getGroupByLastPosition();
        this.appendRest(sqlBuilder, count, sqlTokens, beginPosition);
    }

    private void appendRest(SQLBuilder sqlBuilder, int count, List<SQLToken> sqlTokens, int beginPosition) {
        int endPosition = sqlTokens.size() - 1 == count ? this.originalSQL.length() : sqlTokens.get(count + 1).getBeginPosition();
        sqlBuilder.appendLiterals(this.originalSQL.substring(beginPosition, endPosition));
    }

    public String generateSQL(TableUnit tableUnit, SQLBuilder sqlBuilder) {
        return sqlBuilder.toSQL(this.getTableTokens(tableUnit));
    }

    public String generateSQL(CartesianTableReference cartesianTableReference, SQLBuilder sqlBuilder) {
        return sqlBuilder.toSQL(this.getTableTokens(cartesianTableReference));
    }

    private Map<String, String> getTableTokens(TableUnit tableUnit) {
        HashMap<String, String> tableTokens = new HashMap<String, String>();
        tableTokens.put(tableUnit.getLogicTableName(), tableUnit.getActualTableName());
        Optional<BindingTableRule> bindingTableRule = this.shardingRule.findBindingTableRule(tableUnit.getLogicTableName());
        if (bindingTableRule.isPresent()) {
            tableTokens.putAll(this.getBindingTableTokens(tableUnit, (BindingTableRule)bindingTableRule.get()));
        }
        return tableTokens;
    }

    private Map<String, String> getTableTokens(CartesianTableReference cartesianTableReference) {
        HashMap<String, String> tableTokens = new HashMap<String, String>();
        for (TableUnit each : cartesianTableReference.getTableUnits()) {
            tableTokens.put(each.getLogicTableName(), each.getActualTableName());
            Optional<BindingTableRule> bindingTableRule = this.shardingRule.findBindingTableRule(each.getLogicTableName());
            if (!bindingTableRule.isPresent()) continue;
            tableTokens.putAll(this.getBindingTableTokens(each, (BindingTableRule)bindingTableRule.get()));
        }
        return tableTokens;
    }

    private Map<String, String> getBindingTableTokens(TableUnit tableUnit, BindingTableRule bindingTableRule) {
        HashMap<String, String> result = new HashMap<String, String>();
        for (String eachTable : this.sqlStatement.getTables().getTableNames()) {
            if (eachTable.equalsIgnoreCase(tableUnit.getLogicTableName()) || !bindingTableRule.hasLogicTable(eachTable)) continue;
            result.put(eachTable, bindingTableRule.getBindingActualTable(tableUnit.getDataSourceName(), eachTable, tableUnit.getActualTableName()));
        }
        return result;
    }
}

