/*
 * Decompiled with CFR 0.152.
 */
package io.shardingjdbc.core.routing.type.complex;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import io.shardingjdbc.core.routing.type.RoutingEngine;
import io.shardingjdbc.core.routing.type.RoutingResult;
import io.shardingjdbc.core.routing.type.TableUnit;
import io.shardingjdbc.core.routing.type.complex.CartesianRoutingResult;
import io.shardingjdbc.core.routing.type.complex.CartesianTableReference;
import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CartesianRoutingEngine
implements RoutingEngine {
    private static final Logger log = LoggerFactory.getLogger(CartesianRoutingEngine.class);
    private final Collection<RoutingResult> routingResults;

    @Override
    public CartesianRoutingResult route() {
        CartesianRoutingResult result = new CartesianRoutingResult();
        for (Map.Entry<String, Set<String>> entry : this.getDataSourceLogicTablesMap().entrySet()) {
            List<Set<String>> actualTableGroups = this.getActualTableGroups(entry.getKey(), entry.getValue());
            List<Set<TableUnit>> tableUnitGroups = this.toTableUnitGroups(entry.getKey(), actualTableGroups);
            result.merge(entry.getKey(), this.getCartesianTableReferences(Sets.cartesianProduct(tableUnitGroups)));
        }
        log.trace("cartesian tables sharding result: {}", (Object)result);
        return result;
    }

    private Map<String, Set<String>> getDataSourceLogicTablesMap() {
        Collection<String> intersectionDataSources = this.getIntersectionDataSources();
        HashMap<String, Set<String>> result = new HashMap<String, Set<String>>(this.routingResults.size());
        for (RoutingResult each : this.routingResults) {
            for (Map.Entry<String, Set<String>> entry : each.getTableUnits().getDataSourceLogicTablesMap(intersectionDataSources).entrySet()) {
                if (result.containsKey(entry.getKey())) {
                    ((Set)result.get(entry.getKey())).addAll((Collection)entry.getValue());
                    continue;
                }
                result.put(entry.getKey(), entry.getValue());
            }
        }
        return result;
    }

    private Collection<String> getIntersectionDataSources() {
        HashSet<String> result = new HashSet<String>();
        for (RoutingResult each : this.routingResults) {
            if (result.isEmpty()) {
                result.addAll(each.getTableUnits().getDataSourceNames());
            }
            result.retainAll(each.getTableUnits().getDataSourceNames());
        }
        return result;
    }

    private List<Set<String>> getActualTableGroups(String dataSource, Set<String> logicTables) {
        ArrayList<Set<String>> result = new ArrayList<Set<String>>(logicTables.size());
        for (RoutingResult each : this.routingResults) {
            result.addAll(each.getTableUnits().getActualTableNameGroups(dataSource, logicTables));
        }
        return result;
    }

    private List<Set<TableUnit>> toTableUnitGroups(final String dataSource, List<Set<String>> actualTableGroups) {
        ArrayList<Set<TableUnit>> result = new ArrayList<Set<TableUnit>>(actualTableGroups.size());
        for (Set<String> each : actualTableGroups) {
            result.add(new HashSet(Lists.transform(new ArrayList<String>(each), (Function)new Function<String, TableUnit>(){

                public TableUnit apply(String input) {
                    return CartesianRoutingEngine.this.findTableUnit(dataSource, input);
                }
            })));
        }
        return result;
    }

    private TableUnit findTableUnit(String dataSource, String actualTable) {
        for (RoutingResult each : this.routingResults) {
            Optional<TableUnit> result = each.getTableUnits().findTableUnit(dataSource, actualTable);
            if (!result.isPresent()) continue;
            return (TableUnit)result.get();
        }
        throw new IllegalStateException(String.format("Cannot found routing table factor, data source: %s, actual table: %s", dataSource, actualTable));
    }

    private List<CartesianTableReference> getCartesianTableReferences(Set<List<TableUnit>> cartesianTableUnitGroups) {
        ArrayList<CartesianTableReference> result = new ArrayList<CartesianTableReference>(cartesianTableUnitGroups.size());
        for (List<TableUnit> each : cartesianTableUnitGroups) {
            result.add(new CartesianTableReference(each));
        }
        return result;
    }

    @ConstructorProperties(value={"routingResults"})
    public CartesianRoutingEngine(Collection<RoutingResult> routingResults) {
        this.routingResults = routingResults;
    }
}

