/*
 * Decompiled with CFR 0.152.
 */
package io.shardingjdbc.core.yaml.masterslave;

import io.shardingjdbc.core.api.algorithm.masterslave.MasterSlaveLoadBalanceAlgorithmType;
import io.shardingjdbc.core.api.config.MasterSlaveRuleConfiguration;
import io.shardingjdbc.core.rule.MasterSlaveRule;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.sql.DataSource;

public class YamMasterSlaveRuleConfiguration {
    private Map<String, DataSource> dataSources = new HashMap<String, DataSource>();
    private String name;
    private String masterDataSourceName;
    private Collection<String> slaveDataSourceNames = new ArrayList<String>();
    private MasterSlaveLoadBalanceAlgorithmType loadBalanceAlgorithmType;
    private String loadBalanceAlgorithmClassName;
    private Properties props = new Properties();

    public MasterSlaveRule getMasterSlaveRule(Map<String, DataSource> dataSourceMap) throws SQLException {
        return this.getMasterSlaveRuleConfiguration().build(dataSourceMap.isEmpty() ? this.dataSources : dataSourceMap);
    }

    public MasterSlaveRuleConfiguration getMasterSlaveRuleConfiguration() {
        MasterSlaveRuleConfiguration result = new MasterSlaveRuleConfiguration();
        result.setName(this.name);
        result.setMasterDataSourceName(this.masterDataSourceName);
        result.setSlaveDataSourceNames(this.slaveDataSourceNames);
        result.setLoadBalanceAlgorithmType(this.loadBalanceAlgorithmType);
        result.setLoadBalanceAlgorithmClassName(this.loadBalanceAlgorithmClassName);
        return result;
    }

    public Map<String, DataSource> getDataSources() {
        return this.dataSources;
    }

    public String getName() {
        return this.name;
    }

    public String getMasterDataSourceName() {
        return this.masterDataSourceName;
    }

    public Collection<String> getSlaveDataSourceNames() {
        return this.slaveDataSourceNames;
    }

    public MasterSlaveLoadBalanceAlgorithmType getLoadBalanceAlgorithmType() {
        return this.loadBalanceAlgorithmType;
    }

    public String getLoadBalanceAlgorithmClassName() {
        return this.loadBalanceAlgorithmClassName;
    }

    public Properties getProps() {
        return this.props;
    }

    public void setDataSources(Map<String, DataSource> dataSources) {
        this.dataSources = dataSources;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setMasterDataSourceName(String masterDataSourceName) {
        this.masterDataSourceName = masterDataSourceName;
    }

    public void setSlaveDataSourceNames(Collection<String> slaveDataSourceNames) {
        this.slaveDataSourceNames = slaveDataSourceNames;
    }

    public void setLoadBalanceAlgorithmType(MasterSlaveLoadBalanceAlgorithmType loadBalanceAlgorithmType) {
        this.loadBalanceAlgorithmType = loadBalanceAlgorithmType;
    }

    public void setLoadBalanceAlgorithmClassName(String loadBalanceAlgorithmClassName) {
        this.loadBalanceAlgorithmClassName = loadBalanceAlgorithmClassName;
    }

    public void setProps(Properties props) {
        this.props = props;
    }
}

