/*
 * Decompiled with CFR 0.152.
 */
package io.shardingjdbc.core.yaml.sharding;

import io.shardingjdbc.core.api.config.MasterSlaveRuleConfiguration;
import io.shardingjdbc.core.api.config.ShardingRuleConfiguration;
import io.shardingjdbc.core.rule.ShardingRule;
import io.shardingjdbc.core.yaml.masterslave.YamMasterSlaveRuleConfiguration;
import io.shardingjdbc.core.yaml.sharding.YamlShardingStrategyConfiguration;
import io.shardingjdbc.core.yaml.sharding.YamlTableRuleConfiguration;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.sql.DataSource;

public class YamlShardingRuleConfiguration {
    private Map<String, DataSource> dataSources = new HashMap<String, DataSource>();
    private String defaultDataSourceName;
    private Map<String, YamlTableRuleConfiguration> tables = new HashMap<String, YamlTableRuleConfiguration>();
    private List<String> bindingTables = new ArrayList<String>();
    private YamlShardingStrategyConfiguration defaultDatabaseStrategy;
    private YamlShardingStrategyConfiguration defaultTableStrategy;
    private String defaultKeyGeneratorClass;
    private Map<String, YamMasterSlaveRuleConfiguration> masterSlaveRules = new HashMap<String, YamMasterSlaveRuleConfiguration>();
    private Properties props = new Properties();

    public ShardingRule getShardingRule(Map<String, DataSource> dataSourceMap) throws SQLException {
        return this.getShardingRuleConfiguration().build(dataSourceMap.isEmpty() ? this.dataSources : dataSourceMap);
    }

    public ShardingRuleConfiguration getShardingRuleConfiguration() {
        ShardingRuleConfiguration result = new ShardingRuleConfiguration();
        result.setDefaultDataSourceName(this.defaultDataSourceName);
        for (Map.Entry<String, YamlTableRuleConfiguration> entry : this.tables.entrySet()) {
            YamlTableRuleConfiguration tableRuleConfig = entry.getValue();
            tableRuleConfig.setLogicTable(entry.getKey());
            result.getTableRuleConfigs().add(tableRuleConfig.build());
        }
        result.getBindingTableGroups().addAll(this.bindingTables);
        if (null != this.defaultDatabaseStrategy) {
            result.setDefaultDatabaseShardingStrategyConfig(this.defaultDatabaseStrategy.build());
        }
        if (null != this.defaultTableStrategy) {
            result.setDefaultTableShardingStrategyConfig(this.defaultTableStrategy.build());
        }
        result.setDefaultKeyGeneratorClass(this.defaultKeyGeneratorClass);
        LinkedList<MasterSlaveRuleConfiguration> masterSlaveRuleConfigs = new LinkedList<MasterSlaveRuleConfiguration>();
        for (Map.Entry<String, YamMasterSlaveRuleConfiguration> each : this.masterSlaveRules.entrySet()) {
            MasterSlaveRuleConfiguration config = new MasterSlaveRuleConfiguration();
            config.setName(each.getKey());
            config.setMasterDataSourceName(each.getValue().getMasterDataSourceName());
            config.setSlaveDataSourceNames(each.getValue().getSlaveDataSourceNames());
            config.setLoadBalanceAlgorithmType(each.getValue().getLoadBalanceAlgorithmType());
            config.setLoadBalanceAlgorithmClassName(each.getValue().getLoadBalanceAlgorithmClassName());
            masterSlaveRuleConfigs.add(config);
        }
        result.setMasterSlaveRuleConfigs(masterSlaveRuleConfigs);
        return result;
    }

    public Map<String, DataSource> getDataSources() {
        return this.dataSources;
    }

    public String getDefaultDataSourceName() {
        return this.defaultDataSourceName;
    }

    public Map<String, YamlTableRuleConfiguration> getTables() {
        return this.tables;
    }

    public List<String> getBindingTables() {
        return this.bindingTables;
    }

    public YamlShardingStrategyConfiguration getDefaultDatabaseStrategy() {
        return this.defaultDatabaseStrategy;
    }

    public YamlShardingStrategyConfiguration getDefaultTableStrategy() {
        return this.defaultTableStrategy;
    }

    public String getDefaultKeyGeneratorClass() {
        return this.defaultKeyGeneratorClass;
    }

    public Map<String, YamMasterSlaveRuleConfiguration> getMasterSlaveRules() {
        return this.masterSlaveRules;
    }

    public Properties getProps() {
        return this.props;
    }

    public void setDataSources(Map<String, DataSource> dataSources) {
        this.dataSources = dataSources;
    }

    public void setDefaultDataSourceName(String defaultDataSourceName) {
        this.defaultDataSourceName = defaultDataSourceName;
    }

    public void setTables(Map<String, YamlTableRuleConfiguration> tables) {
        this.tables = tables;
    }

    public void setBindingTables(List<String> bindingTables) {
        this.bindingTables = bindingTables;
    }

    public void setDefaultDatabaseStrategy(YamlShardingStrategyConfiguration defaultDatabaseStrategy) {
        this.defaultDatabaseStrategy = defaultDatabaseStrategy;
    }

    public void setDefaultTableStrategy(YamlShardingStrategyConfiguration defaultTableStrategy) {
        this.defaultTableStrategy = defaultTableStrategy;
    }

    public void setDefaultKeyGeneratorClass(String defaultKeyGeneratorClass) {
        this.defaultKeyGeneratorClass = defaultKeyGeneratorClass;
    }

    public void setMasterSlaveRules(Map<String, YamMasterSlaveRuleConfiguration> masterSlaveRules) {
        this.masterSlaveRules = masterSlaveRules;
    }

    public void setProps(Properties props) {
        this.props = props;
    }
}

