/*
 * Decompiled with CFR 0.152.
 */
package io.shardingsphere.shardingjdbc.jdbc.core;

import io.shardingsphere.core.constant.DatabaseType;
import io.shardingsphere.core.executor.ShardingExecuteEngine;
import io.shardingsphere.core.metadata.ShardingMetaData;
import io.shardingsphere.core.metadata.table.executor.TableMetaDataConnectionManager;
import io.shardingsphere.core.rule.ShardingRule;
import io.shardingsphere.shardingjdbc.jdbc.metadata.JDBCTableMetaDataConnectionManager;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.sql.DataSource;

public final class ShardingContext
implements AutoCloseable {
    private final ShardingRule shardingRule;
    private final DatabaseType databaseType;
    private final ShardingExecuteEngine executeEngine;
    private final int maxConnectionsSizePerQuery;
    private final boolean showSQL;
    private final ShardingMetaData metaData;

    public ShardingContext(Map<String, DataSource> dataSourceMap, ShardingRule shardingRule, DatabaseType databaseType, ShardingExecuteEngine executeEngine, int maxConnectionsSizePerQuery, boolean showSQL) throws SQLException {
        this.shardingRule = shardingRule;
        this.databaseType = databaseType;
        this.executeEngine = executeEngine;
        this.maxConnectionsSizePerQuery = maxConnectionsSizePerQuery;
        this.showSQL = showSQL;
        this.metaData = new ShardingMetaData(this.getDataSourceURLs(dataSourceMap), shardingRule, databaseType, executeEngine, (TableMetaDataConnectionManager)new JDBCTableMetaDataConnectionManager(dataSourceMap), maxConnectionsSizePerQuery);
    }

    private Map<String, String> getDataSourceURLs(Map<String, DataSource> dataSourceMap) throws SQLException {
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>(dataSourceMap.size(), 1.0f);
        for (Map.Entry<String, DataSource> entry : dataSourceMap.entrySet()) {
            result.put(entry.getKey(), this.getDataSourceURL(entry.getValue()));
        }
        return result;
    }

    private String getDataSourceURL(DataSource dataSource) throws SQLException {
        try (Connection connection = dataSource.getConnection();){
            String string = connection.getMetaData().getURL();
            return string;
        }
    }

    @Override
    public void close() {
        this.executeEngine.close();
    }

    public ShardingRule getShardingRule() {
        return this.shardingRule;
    }

    public DatabaseType getDatabaseType() {
        return this.databaseType;
    }

    public ShardingExecuteEngine getExecuteEngine() {
        return this.executeEngine;
    }

    public int getMaxConnectionsSizePerQuery() {
        return this.maxConnectionsSizePerQuery;
    }

    public boolean isShowSQL() {
        return this.showSQL;
    }

    public ShardingMetaData getMetaData() {
        return this.metaData;
    }
}

