/*
 * Decompiled with CFR 0.152.
 */
package io.shardingsphere.shardingjdbc.jdbc.core.datasource;

import io.shardingsphere.api.ConfigMapContext;
import io.shardingsphere.api.config.MasterSlaveRuleConfiguration;
import io.shardingsphere.core.constant.properties.ShardingProperties;
import io.shardingsphere.core.constant.properties.ShardingPropertiesConstant;
import io.shardingsphere.core.rule.MasterSlaveRule;
import io.shardingsphere.shardingjdbc.jdbc.adapter.AbstractDataSourceAdapter;
import io.shardingsphere.shardingjdbc.jdbc.core.connection.MasterSlaveConnection;
import java.lang.reflect.Method;
import java.sql.SQLException;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Properties;
import javax.sql.DataSource;

public class MasterSlaveDataSource
extends AbstractDataSourceAdapter
implements AutoCloseable {
    private final Map<String, DataSource> dataSourceMap;
    private final MasterSlaveRule masterSlaveRule;
    private final ShardingProperties shardingProperties;

    public MasterSlaveDataSource(Map<String, DataSource> dataSourceMap, MasterSlaveRuleConfiguration masterSlaveRuleConfig, Map<String, Object> configMap, Properties props) throws SQLException {
        super(MasterSlaveDataSource.getAllDataSources(dataSourceMap, masterSlaveRuleConfig.getMasterDataSourceName(), masterSlaveRuleConfig.getSlaveDataSourceNames()));
        if (!configMap.isEmpty()) {
            ConfigMapContext.getInstance().getMasterSlaveConfig().putAll(configMap);
        }
        this.dataSourceMap = dataSourceMap;
        this.masterSlaveRule = new MasterSlaveRule(masterSlaveRuleConfig);
        this.shardingProperties = new ShardingProperties(null == props ? new Properties() : props);
    }

    public MasterSlaveDataSource(Map<String, DataSource> dataSourceMap, MasterSlaveRule masterSlaveRule, Map<String, Object> configMap, ShardingProperties props) throws SQLException {
        super(MasterSlaveDataSource.getAllDataSources(dataSourceMap, masterSlaveRule.getMasterDataSourceName(), masterSlaveRule.getSlaveDataSourceNames()));
        if (!configMap.isEmpty()) {
            ConfigMapContext.getInstance().getMasterSlaveConfig().putAll(configMap);
        }
        this.dataSourceMap = dataSourceMap;
        this.masterSlaveRule = masterSlaveRule;
        this.shardingProperties = props;
    }

    private static Collection<DataSource> getAllDataSources(Map<String, DataSource> dataSourceMap, String masterDataSourceName, Collection<String> slaveDataSourceNames) {
        LinkedList<DataSource> result = new LinkedList<DataSource>();
        result.add(dataSourceMap.get(masterDataSourceName));
        for (String each : slaveDataSourceNames) {
            result.add(dataSourceMap.get(each));
        }
        return result;
    }

    public Map<String, DataSource> getAllDataSources() {
        HashMap<String, DataSource> result = new HashMap<String, DataSource>(this.masterSlaveRule.getSlaveDataSourceNames().size() + 1, 1.0f);
        result.put(this.masterSlaveRule.getMasterDataSourceName(), this.getDataSourceMap().get(this.masterSlaveRule.getMasterDataSourceName()));
        for (String each : this.masterSlaveRule.getSlaveDataSourceNames()) {
            result.put(each, this.getDataSourceMap().get(each));
        }
        return result;
    }

    private void closeOriginalDataSources() {
        for (DataSource each : this.getDataSourceMap().values()) {
            try {
                Method closeMethod = each.getClass().getDeclaredMethod("close", new Class[0]);
                closeMethod.invoke((Object)each, new Object[0]);
            }
            catch (ReflectiveOperationException reflectiveOperationException) {}
        }
    }

    @Override
    public final MasterSlaveConnection getConnection() {
        return new MasterSlaveConnection(this);
    }

    @Override
    public final void close() {
        this.closeOriginalDataSources();
    }

    public boolean showSQL() {
        return (Boolean)this.shardingProperties.getValue(ShardingPropertiesConstant.SQL_SHOW);
    }

    public Map<String, DataSource> getDataSourceMap() {
        return this.dataSourceMap;
    }

    public MasterSlaveRule getMasterSlaveRule() {
        return this.masterSlaveRule;
    }

    public ShardingProperties getShardingProperties() {
        return this.shardingProperties;
    }
}

