/*
 * Decompiled with CFR 0.152.
 */
package brave.internal;

import brave.Clock;
import brave.Tracer;
import brave.internal.AutoValue_Platform_Jre6;
import brave.internal.AutoValue_Platform_Jre7;
import brave.internal.AutoValue_Platform_Jre9;
import com.google.auto.value.AutoValue;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.time.Instant;
import java.util.Enumeration;
import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jvnet.animal_sniffer.IgnoreJRERequirement;
import zipkin2.Endpoint;
import zipkin2.Span;
import zipkin2.reporter.Reporter;

public abstract class Platform {
    static final Logger logger = Logger.getLogger(Tracer.class.getName());
    private static final Platform PLATFORM = Platform.findPlatform();
    volatile Endpoint localEndpoint;

    public abstract boolean zipkinV1Present();

    public Reporter<Span> reporter() {
        return LoggingReporter.INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Endpoint localEndpoint() {
        if (this.localEndpoint == null) {
            Platform platform = this;
            synchronized (platform) {
                if (this.localEndpoint == null) {
                    this.localEndpoint = this.produceLocalEndpoint();
                }
            }
        }
        return this.localEndpoint;
    }

    Endpoint produceLocalEndpoint() {
        Endpoint.Builder builder;
        block5: {
            builder = Endpoint.newBuilder().serviceName("unknown");
            try {
                Enumeration<NetworkInterface> nics = NetworkInterface.getNetworkInterfaces();
                if (nics == null) {
                    return builder.build();
                }
                block2: while (nics.hasMoreElements()) {
                    NetworkInterface nic = nics.nextElement();
                    Enumeration<InetAddress> addresses = nic.getInetAddresses();
                    while (addresses.hasMoreElements()) {
                        InetAddress address = addresses.nextElement();
                        if (!address.isSiteLocalAddress()) continue;
                        builder.ip(address);
                        continue block2;
                    }
                }
            }
            catch (Exception e) {
                if (!logger.isLoggable(Level.FINE)) break block5;
                logger.log(Level.FINE, "error reading nics", e);
            }
        }
        return builder.build();
    }

    public static Platform get() {
        return PLATFORM;
    }

    static Platform findPlatform() {
        boolean zipkinV1Present;
        try {
            Class.forName("zipkin.Endpoint");
            zipkinV1Present = true;
        }
        catch (ClassNotFoundException e) {
            zipkinV1Present = false;
        }
        Jre9 jre9 = Jre9.buildIfSupported(zipkinV1Present);
        if (jre9 != null) {
            return jre9;
        }
        Jre7 jre7 = Jre7.buildIfSupported(zipkinV1Present);
        if (jre7 != null) {
            return jre7;
        }
        return Jre6.build(zipkinV1Present);
    }

    public abstract long randomLong();

    public abstract long nextTraceIdHigh();

    public Clock clock() {
        return new Clock(){

            @Override
            public long currentTimeMicroseconds() {
                return System.currentTimeMillis() * 1000L;
            }

            public String toString() {
                return "System.currentTimeMillis()";
            }
        };
    }

    static long nextTraceIdHigh(Random prng) {
        long epochSeconds = System.currentTimeMillis() / 1000L;
        int random = prng.nextInt();
        return (epochSeconds & 0xFFFFFFFFL) << 32 | (long)random & 0xFFFFFFFFL;
    }

    @AutoValue
    static abstract class Jre6
    extends Platform {
        Jre6() {
        }

        abstract Random prng();

        static Jre6 build(boolean zipkinV1Present) {
            return new AutoValue_Platform_Jre6(zipkinV1Present, new Random(System.nanoTime()));
        }

        @Override
        public long randomLong() {
            return this.prng().nextLong();
        }

        @Override
        public long nextTraceIdHigh() {
            return Jre6.nextTraceIdHigh(this.prng());
        }
    }

    @AutoValue
    static abstract class Jre7
    extends Platform {
        Jre7() {
        }

        static Jre7 buildIfSupported(boolean zipkinV1Present) {
            try {
                Class.forName("java.util.concurrent.ThreadLocalRandom");
                return new AutoValue_Platform_Jre7(zipkinV1Present);
            }
            catch (ClassNotFoundException classNotFoundException) {
                return null;
            }
        }

        @Override
        @IgnoreJRERequirement
        public long randomLong() {
            return ThreadLocalRandom.current().nextLong();
        }

        @Override
        @IgnoreJRERequirement
        public long nextTraceIdHigh() {
            return Jre7.nextTraceIdHigh(ThreadLocalRandom.current());
        }
    }

    @AutoValue
    static abstract class Jre9
    extends Platform {
        Jre9() {
        }

        static Jre9 buildIfSupported(boolean zipkinV1Present) {
            try {
                Class<?> zoneId = Class.forName("java.time.ZoneId");
                Class.forName("java.time.Clock").getMethod("tickMillis", zoneId);
                return new AutoValue_Platform_Jre9(zipkinV1Present);
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
            return null;
        }

        @Override
        @IgnoreJRERequirement
        public Clock clock() {
            return new Clock(){

                @Override
                public long currentTimeMicroseconds() {
                    Instant instant = java.time.Clock.systemUTC().instant();
                    return instant.getEpochSecond() * 1000000L + (long)(instant.getNano() / 1000);
                }

                public String toString() {
                    return "Clock.systemUTC().instant()";
                }
            };
        }

        @Override
        @IgnoreJRERequirement
        public long randomLong() {
            return ThreadLocalRandom.current().nextLong();
        }

        @Override
        @IgnoreJRERequirement
        public long nextTraceIdHigh() {
            return Jre9.nextTraceIdHigh(ThreadLocalRandom.current());
        }
    }

    static enum LoggingReporter implements Reporter<Span>
    {
        INSTANCE;


        public void report(Span span) {
            if (!logger.isLoggable(Level.INFO)) {
                return;
            }
            if (span == null) {
                throw new NullPointerException("span == null");
            }
            logger.info(span.toString());
        }

        public String toString() {
            return "LoggingReporter{name=" + logger.getName() + "}";
        }
    }
}

